package com.inzyme.spatiotemporal.common.utils;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;
 
public class PageUtil {
 
    /**
     * @Description:转换为 IPage 对象
     * @Author: yifan.wang
     * @Date: 2023/2/20 15:40
     */
    public static <T, E> IPage<T> copy(IPage page, List<E> sourceList, Class<T> targetClazz) {
        IPage pageResult = new Page(page.getCurrent(),page.getSize(),page.getTotal());
        pageResult.setPages(page.getPages());
        List<T> records = BeanUtil.copyToList(sourceList, targetClazz);
        pageResult.setRecords(records);
        return pageResult;
    }
 
    /**
     * @Description:转换为 IPage 对象
     * @Author: tarzan
     * @Date: 2019/10/31 9:40
     */
    public static <T, E> IPage<T> copy(IPage page, Class<T> targetClazz) {
        return copy(page,page.getRecords(),targetClazz);
    }
 
}