package com.inzyme.spatiotemporal.common.utils;

import com.google.common.collect.ImmutableList;
import org.apache.poi.xssf.usermodel.XSSFColor;

import java.awt.*;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName: ExpoConstants
 * @Description: 展会平台 专用 常量
 * @date 2020年4月23日 下午4:21:27
 *
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
public class ObmsConstants {

	/**
	 * 洛杉矶时区
	 */
//	public static final String TimeZone = "America/Los_Angeles";
//	public static final String TimeGMT = "GMT-7";					// 实体 to json 时间字段注解时区配置项目

	/**
	 * 上海时区
	 */
	public static final String TimeZone = "Asia/Shanghai";
	public static final String TimeGMT = "GMT+8";					// 实体 to json 时间字段注解时区配置项目

	/**
	 * 消息类型channel-发送消息
	 */
	public static final String sendMessageChannel = "sendMessage";

	/**
	 * 推送消息通道, 用户完善信息的时候, 首次注册, 会给用户推送一条短信, 短信的内容包括用户的面膜, PC 端管理的地址等信息
	 */
	public static final String MEM_REGISTRY_MESSAGE_CHANNEL = "memRegistryMessageChannel";

	/**
	 * 发送展会任务提醒消息channel
	 */
	public static final String SEND_EXPOTASK_MESSAGE_CHANNEL="sendExpoTaskMessageChannel";
	/**
	 * 发送展会任务微信提醒消息channel
	 */
	public static final String SEND_EXPOTASK_WXMESSAGE_CHANNEL="sendExpoTaskWXMessageChannel";

	/**
	 * 发送展会嘉宾审核提醒消息channel
	 */
	public static final String SEND_GUNEST_MESSAGE_CHANNEL="sendExpoTaskMessageChannel";

	// 处理展会流水channel
	public static final String MALL_EXPO_WALLET_CHANNEL = "mallExpoWalletChannel";

	/** 逻辑删除判断字段 */
	public static final Integer NOT_DELETED = 0;
	public static final Integer DELETED = 1;
	public static final String ADMIN = "0";
	public static final String USER = "1";

	/**用户登录路径 web登录与pc登录*/
	public static final String REQ_FROM_WEB = "web";	//
	public static final String REQ_FROM_APP_B = "appB";	// app-B端
	public static final String REQ_FROM_APP_C = "appC";	// app-C端

	/** 运营人员登录token过期时间 **/
	public static final Integer SYSTEM_USER_TOKEN_EXPIRATION_TIME = 3600;// web-core定义了在redis存在1800秒，所以大于1800的都未生效

	/**
	 * APP侧token过期时间
	 */
	public static final Integer APP_USER_TOKEN_EXPIRATION_TIME = 3600 * 24 * 20;



	/**
	 * 验证码专用段 REDIS_KEY_CAPTCHA + mobile
	 */
	public static final String REDIS_KEY_CAPTCHA = "tydicata:spatialdata:captcha";

	/**
	 * im侧usersig缓存专用段
	 */
	public static final String REDIS_KEY_USERSIG = "tydicata:spatialdata:usersig:";

	/** 运营平台key **/
	public static final String REDIS_KEY_USERNAME = "tydicata:spatialdata:username";

	/**
	 * token专用段 REDIS_KEY_TOKEN + mobile
	 */
	public static final String REDIS_KEY_TOKEN = "tydicata:spatialdata:custoken";

	/**
	 * web端 token专用段 REDIS_KEY_TOKEN_WEB + mobile
	 */
	public static final String REDIS_KEY_TOKEN_WEB = "tydicata:spatialdata:custoken:web";
	/**
	 * 微信toke
	 */
	public static final String ACCESS_TOKEN = "tydicata:spatialdata:custoken:wx";

	/**
	 * 平台App运行量缓存段
	 */
	public static final String REDIS_KEY_RUNAPP = "tydicata:expodata:runapp";

	/**
	 * 平台App运行量缓存段
	 */
	public static final String REDIS_KEY_USERSTATE = "tydicata:expodata:userstate";
	public static final String WEB_TOKEN_FLAG = "X-Token";
	public static final String DEPARTMENT_KEY = "inzyme:spatialdata:org:department";
	public static final String DEPARTMENT_ID_KEY = "inzyme:spatialdata:org:departmentId";
	public static final String SECTION_KEY = "inzyme:spatialdata:org:section" ;
	public static final String SUB_SECTION_KEY = "inzyme:spatialdata:org:subsection";
	public static final String CLASS_KEY = "inzyme:spatialdata:org:class" ;
	public static final String ORG_NAME_KEY = "inzyme:spatialdata:org:orgname";
	public static final String STAFF_SCHEDULE_KEY = "inzyme:StaffScheduleUpdateVO";
	public static final String CHANGE_PASSWORD_KEY = "inzyme:spatialdata:login";//找回密码的key
	public static final String LOGIN_COUNT_KEY = "inzyme:spatialdata:loginCount";//登录错误的次数
	public static final String MAIL_LOGIN_KEY = "inzyme:spatialdata:mailLogin";//邮件链接用户名的key
	public static final String LOGIN_TOKEN_KEY ="inzyme:spatialdata:username";
	public static final String WX_KEY ="inzyme:spatialdata:wx:list";
	/**
	 * 下发门禁缓存的入参
	 * */
	public static final String ACCESS_KEY = "inzyme:spatialdata:hk:config";
	/**
	 * 进行配置门禁权限
	 * */
	public static final String AUTHORITY_KEY = "inzyme:spatialdata:hk:hikPeopleId";
	/**
	 * 存入异动完成的信息
	 * */
	public static final String MOVE_KEY = "inzyme:spatialdata:hk:move";
	/**
	 * 存入排班管理的入参
	 * */
	public static final String WORKING_SCHEDULE_KEY = "inzyme:spatialdata:classes:work";
	/**
	 * 消息重试次数
	 */
	public static int MAX_RETRY = 3;

	/**
	 * 队列消费超时时间
	 */
	public static int CONSUMER_POLL_TIME = 5;

	/**
	 * 队列最大消费线程数
	 */
	public static int MAX_CONSUMER_THREADS = 5;

	/**
	 * 死信队列名
	 */
	public static String DEAD_LETTER_QUEUE = "dead-queue-event";

	/**
	 * 是否开启死信
	 */
	public static boolean enableDeadLetterQueue = true;

	/**
	 * 签名字段 - mall_order
	 */
	public static final List<String> SIGNFIELD4MALL_ORDER = ImmutableList.of("pay_account",	"order_no", "mem_id", "payment_amount");

	/**
	 * 签名字段 - mall_order_item
	 */
	public static final List<String> SIGNFIELD4MALL_ORDER_ITEM = ImmutableList.of("order_no", "expo_id", "prod_spec_id", "prod_price_id", "count", "sale_price", "payment_price", "brokerage_fee");

	/**
	 * 签名字段 - mall_redeem
	 */
	public static final List<String> SIGNFIELD4MALL_REDEEM = ImmutableList.of("order_no", "order_item_id", "mem_id", "expo_id", "prod_price_id", "code");

	/**
	 * 签名字段 - mall_order_payment
	 */
	public static final List<String> SIGNFIELD4MALL_ORDER_PAYMENT = ImmutableList.of("order_no", "mem_id", "order_amount");

	/**
	 * 签名字段 - mall_expo_wallet_log
	 */
	public static final List<String> SIGNFIELD4MALL_EXPO_WALLET_LOG = ImmutableList.of("expo_id", "target_type", "target_id", "amount", "brokerage_fee", "income");

	/**
	 * 签名字段 - mall_expo_wallet
	 */
	public static final List<String> SIGNFIELD4MALL_EXPO_WALLET = ImmutableList.of("expo_id", "wallet_income", "wallet_outcome", "balance_fee", "frozen");

	/**
	 * 定时任务状态
	 *
	 * @author Inzymeits
	 * @date 2017年8月8日 下午1:36:17
	 */
	public enum ScheduleStatus {
		/** 正常 */
		NORMAL(1),
		/** 暂停 */
		PAUSE(0);

		private int value;

		ScheduleStatus(int value) {
			this.value = value;
		}

		public int getValue() {
			return value;
		}
	}

    /** 延时队列类型：订单xx分钟后未支付自动取消*/
    public static final String DELAYED_TYPE_ORDER = "delayedTypeOrder";

	/** 数据标识 */
	public static final String DATA_ROWS = "rows";

	/** 删除时，提示有子节点无法删除 */
	public static final String MSG_HAS_CHILD = "操作失败，当前所选栏目有子栏目信息！";

	/** 默认分页值 */
	public static final Long PAGE_CURRENT = 0L;
	public static final Long PAGE_SIZE = 20L;

	/** 动态图文混排 - 图片占位符 - 替换图片服务器前缀 **/
	public static final String MOMENT_IMAGES_ROOT_URL = "\\#\\{moment_images_root_url\\}\\#";

	/** 订单状态（-1退款；0待支付；1订单取消；3已支付；5支付成功；7支付失败；）*/
	/** 订单状态：-1退款 **/
    public static final Integer STATE_MALL_ORDER_REMOVE = -1;
    /** 订单状态：0待支付 **/
    public static final Integer STATE_MALL_ORDER_WAIT = 0;
    /** 订单状态：1订单取消**/
    public static final Integer STATE_MALL_ORDER_CANCEL = 1;
    /** 订单状态：3已支付 **/
    public static final Integer STATE_MALL_ORDER_PAY_UNKNOW = 3;
    /** 订单状态：5支付成功 **/
    public static final Integer STATE_MALL_ORDER_PAY_SUCCESS = 5;
    /** 订单状态：7支付失败 **/
    public static final Integer STATE_MALL_ORDER_PAY_FAILED = 7;

    /** 延时任务类型*/
    /** 延时队列常量：创建订单后，不缴费自动取消订单的时间(分钟)*/
    public static final Integer DELAYED_TIME_MALL_ORDER_CREATE = 30;
	/** 延时队列类型：创建订单30分钟后自动取消 */
	public static final String DELAYED_TYPE_MALL_ORDER_CREATE = "delayedTypeMallOrderCreate";

    /** 日期格式的日期格式化工具类 */
	public static final SimpleDateFormat DAY_FORMAT= new SimpleDateFormat("yyyy-MM-dd");
	/** 日期+时间的 时间格式化工具类*/
	public static final SimpleDateFormat DATETIME_FORMAT= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	/** 如果值为空，给出默认值为0D **/
	public static final Double DEFAULT_ZERO_DOUBLE = 0.0D;

	/** 购物车最多数量20 **/
	public static final Integer CART_FULL = 20;

	/** 短信验证码接口URL **/
    public static final String VERIFICATION_CODE_POST_URL = "http://mass.baobeituan.com/sms/v1/single";
    /** 短信验证码接口URL（多人） **/
    public static final String VERIFICATION_CODE_POST_URL_MORE = "http://mass.baobeituan.com/sms/v1/more";
    /** 短信验证码模板 **/
    public static final String VERIFICATION_CODE_TEMPLATE = "【东本储运】验证码：${verCode}（若非本人操作，请删除本短信） 回T退订";
    /** 推送短信模板 */
    public static final String PUSH_MESSAGE_TEMPLATE = "【东本储运】尊敬的用户, 您好! 会务小程序感谢您的注册, 您的初始密码为手机号后六位是：${loginPassword},请到 ${pcLoginAddress} 进行登录, 谢谢!";
	/** 推送展会任务短信模板 */
	public static final String PUSH_EXPOTASK_MESSAGE_TEMPLATE = "【东本储运】尊敬的用户, 您好! ${message}。";

	/**
	 * excel类型
	 */
	public static final String XLSX = "xlsx";
	public static final String XLS = "xls";
	public static final String SHEETS = "Sheets";

	/**
	 * 企业微信url
	 */
	public static final String WXURL = "https://qyapi.weixin.qq.com/";

	public static final String HIK_HOST = "http://172.16.1.129:9016";
	public final static String HIK_SECRET ="n9YSEq3bCUW3xwZzJwGp";
	public final static String HIK_APP_KEY  ="22173822";

	public final  static  Map<String, XSSFColor> COLOR_MAP =  new HashMap();
	static  {
		COLOR_MAP.put("缺勤",new XSSFColor(new Color(238,203,173)));
		COLOR_MAP.put("迟到",new XSSFColor(new Color(238,224,229)));
		COLOR_MAP.put("休息",new XSSFColor(new Color(238,180,34)));
		COLOR_MAP.put("早退",new XSSFColor(new Color(238,213,210)));
		COLOR_MAP.put("旷工",new XSSFColor(new Color(205,186,150)));
		COLOR_MAP.put("即迟到又早退",new XSSFColor(new Color(205,155,155)));
	}

	public static void main(String[] args) {
		final XSSFColor xssfColor = new XSSFColor(new Color(128, 50, 128));
	}
}
