package com.inzyme.spatiotemporal.common.utils;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;

/**   
 * @ClassName: MessageID    
 * @Description: 生成message id
 * @date 2022年6月28日 下午2:40:08    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
*/
public class MessageID {
	
	/**
	 * 自然灾害通知单
	 * @return
	 */
	public static String generateNutreMsgId() {
		return generateId("N");
	}
	/**
	 * 
	 * @Title: generatePowerMsgId    
	 * @Description: 生成电力通知单messageId
	 * @param type
	 * @return  
	 * String
	 */
	public static String generatePowerMsgId() {
		return generateId("P");
	}
	
	/**
	 * 
	 * @Title: generateIotMsgId    
	 * @Description: 生成物联感知通知单messageId
	 * @param type
	 * @return  
	 * String
	 */
	public static String generateIotMsgId() {
		return generateId("I");
	}
	
	/**
	 * 
	 * @Title: generateId    
	 * @Description: 生成ID
	 * @param type
	 * @return  
	 * String
	 */
	private static String generateId(String type) {
		return type + IdUtil.getSnowflake(RandomUtil.randomInt(1, 15), RandomUtil.randomInt(16, 30)).nextId();
	}
}
