package com.inzyme.spatiotemporal.common.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;

import com.alibaba.fastjson.JSONObject;
import com.inzyme.spatiotemporal.common.domain.entity.GpsPoints;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class GeotoolsUtils {
	private static GeometryFactory geometryFactory = new GeometryFactory();
	
	/**
	 * 
	 * @Title: withinGeo    
	 * @Description: 判断以x,y为坐标的点point(x,y)是否在geometry表示的Polygon中
	 * @param x 
	 * @param y
	 * @param geometry	wkt格式
	 * @return
	 * @throws ParseException  
	 * boolean
	 */
	public static boolean withInGeo(double x, double y, String geometry) throws ParseException {
		Coordinate coord = new Coordinate(x, y);
		Point point = geometryFactory.createPoint(coord);
		WKTReader reader = new WKTReader(geometryFactory);
		Polygon polygon = (Polygon) reader.read(geometry);
		return point.within(polygon);
	}

	/**
	 ** 线生成缓冲区
	 * 
	 * @param polyline
	 * @param distance
	 * @return
	 */
	public static String createBuffer(String polyline, int distance) {
		WKTReader reader = new WKTReader();
		Double length = distance * 180 / Math.PI / 6371000;
		try {
			Geometry geometry = reader.read(polyline);
			Geometry bg = geometry.buffer(length);
			return bg.toString();
		} catch (ParseException e) {
			log.error("线生成缓冲区发生错误", e);
		}
		return null;
	}
	
	
	/**
	 ** 点生成缓冲区
	 * 
	 * @param polyline
	 * @param distance
	 * @return
	 */
	public static Geometry createPoineBuffer(String point, int distance) {
		WKTReader reader = new WKTReader();
		Double length = distance * 180 / Math.PI / 6371000;
		try {
			Geometry geometry = reader.read(point);
			Geometry bg = geometry.buffer(length);
			return bg;
		} catch (ParseException e) {
			log.error("线生成缓冲区发生错误", e);
		}
		return null;
	}
	
	/**
	 * 
	 * @Title: withInBuffer    
	 * @Description: 给定点是否在缓冲区内
	 * @param x
	 * @param y
	 * @param polyline
	 * @param distance
	 * @return
	 * @throws ParseException  
	 * boolean
	 */
	public static boolean withInBuffer(double x, double y, String polyline, int distance) throws ParseException {
		boolean inFlag = false;
		String lineBuffer = createBuffer(polyline, distance);
		if(!StringUtils.isEmpty(lineBuffer)) {
			inFlag = withInGeo(x, y, lineBuffer);
		}
		return inFlag;		
	}
	
	 /**
     * GeoJson转Geometry
     *
     * @param geoJson 字符串类型GeoJson
     * @return Geometry
     */
    public static Geometry geoJsonToGeometry(String geoJson) {
        GeometryJSON json = new GeometryJSON();
        Reader reader = new StringReader(geoJson);
        try {
            return json.read(reader);
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }
	 /**
     * wkt转GeoJson（geometry）  不包括属性
     *
     * @param wkt wkt
     * @return geoJson
     */
    public static String wktToJson(String wkt) {
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            StringWriter writer = new StringWriter();
            GeometryJSON g = new GeometryJSON(14);
            g.write(geometry, writer);
            return writer.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    
    
    
	public static void getBox(double x, double y, String geometry) throws ParseException {
		Coordinate coord = new Coordinate(x, y);
		Point point = geometryFactory.createPoint(coord);
		WKTReader reader = new WKTReader(geometryFactory);
		Polygon polygon = (Polygon) reader.read(geometry);
		System.out.println(polygon.getBoundary().toText());
	}
    
	
    
    public static Map<String, Object> wktToJson(String wkt, Map<String, Object> map) {
        String json = null;
        // geoJson
        HashMap<String, Object> feature = new HashMap<>();
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            StringWriter writer = new StringWriter();
            GeometryJSON g = new GeometryJSON(14);
            g.write(geometry, writer);
            JSONObject jsonObject = JSONObject.parseObject(writer.toString());
            feature.put("type", "Feature");
            feature.put("geometry", jsonObject);
            feature.put("properties", map);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return feature;
    }
    /**
     * 数据转换 百度坐标转84坐标
     * @param type
     * @param points
     * @param distance
     * @return
     */
    public static GpsPoints changePoint(String type,String points,Integer distance) {
    	GpsPoints gpsPoints =new GpsPoints();
    	List list84=new ArrayList<>();
    	List listbd=new ArrayList<>();
    	
		String[] a=points.split(";");
		

		for (String str : a) {
			String[] b=str.split(",");
			listbd.add(new Coordinate(Double.valueOf(b[0]),Double.valueOf(b[1])));
			
			double[] wgs84tobd=GPSUtil.bd09towgs84(Double.valueOf(b[0]),Double.valueOf(b[1]));
			
			list84.add(new Coordinate(wgs84tobd[0],wgs84tobd[1]));
		}
		
		if(type.equals("rect")) {
			String[] tt=a[0].split(",");
			listbd.add(new Coordinate(Double.valueOf(tt[0]),Double.valueOf(tt[1])));
			
			double[] wgs84tobd=GPSUtil.bd09towgs84(Double.valueOf(tt[0]),Double.valueOf(tt[1]));
			
			list84.add(new Coordinate(wgs84tobd[0],wgs84tobd[1]));
		}
		Coordinate[] coordinates84 =(Coordinate[]) list84.toArray(new Coordinate[list84.size()]); 
		Coordinate[] coordinatesbd =(Coordinate[]) listbd.toArray(new Coordinate[listbd.size()]); 
		GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
		Geometry areageometry =null;
		Geometry areajson =null;
		if(type.equals("route")) {
			areageometry = gf.createLineString(coordinates84);
		    areajson = gf.createLineString(coordinatesbd);
		}else if(type.equals("circle")) {
			Geometry a84=gf.createPoint((Coordinate) list84.get(0));
			areageometry=createPoineBuffer(a84.toString(), distance);
			
			Geometry abd=gf.createPoint((Coordinate) listbd.get(0));
			areajson=createPoineBuffer(abd.toString(), distance);
			
		}else {
			areageometry = gf.createPolygon(coordinates84);
			areajson=gf.createPolygon(coordinatesbd);
		}
		  JSONObject areaJson = new JSONObject(wktToJson(areajson.toString(), null));
		  
		  String areageometryStr=areageometry.toString();
		  String point84=areageometryStr.substring(areageometryStr.lastIndexOf("(")+1, areageometryStr.lastIndexOf(")")-1);
		  point84=point84.replace(", ", ";");
		  gpsPoints.setGeoString(point84);
		  gpsPoints.setAreaJson(areaJson.toJSONString());
		  gpsPoints.setAreaGeometry(areageometryStr);
		  return gpsPoints;
		  
    }
    
    /**
     * 数据转换 84坐标转百度坐标
     * @param type
     * @param points
     * @param distance
     * @return
     */
    public static GpsPoints changePointold(String type,String points,Integer distance) {
    	GpsPoints gpsPoints =new GpsPoints();
    	List list84=new ArrayList<>();
    	List listbd=new ArrayList<>();
    	
		String[] a=points.split(";");
		for (String str : a) {
			String[] b=str.split(",");
			list84.add(new Coordinate(Double.valueOf(b[0]),Double.valueOf(b[1])));
			
			double[] wgs84tobd=GPSUtil.wgs84tobd09(Double.valueOf(b[0]),Double.valueOf(b[1]));
			
			listbd.add(new Coordinate(wgs84tobd[0],wgs84tobd[1]));
		}
		Coordinate[] coordinates84 =(Coordinate[]) list84.toArray(new Coordinate[list84.size()]); 
		Coordinate[] coordinatesbd =(Coordinate[]) listbd.toArray(new Coordinate[listbd.size()]); 
		GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
		Geometry areageometry =null;
		Geometry areajson =null;
		if(type.equals("route")) {
			areageometry = gf.createLineString(coordinates84);
		    areajson = gf.createLineString(coordinatesbd);
		}else if(type.equals("circle")) {
			Geometry a84=gf.createPoint((Coordinate) list84.get(0));
			areageometry=createPoineBuffer(a84.toString(), distance);
			
			Geometry abd=gf.createPoint((Coordinate) listbd.get(0));
			areajson=createPoineBuffer(abd.toString(), distance);
			
		}else {
			areageometry = gf.createPolygon(coordinates84);
			areajson=gf.createPolygon(coordinatesbd);
		}
		  JSONObject areaJson = new JSONObject(wktToJson(areajson.toString(), null));
		  gpsPoints.setGeoString(points);
		  gpsPoints.setAreaJson(areaJson.toJSONString());
		  gpsPoints.setAreaGeometry(areageometry.toString());
		  return gpsPoints;
		  
    }
	public static void main(String[] args) throws ParseException, IOException {
		
		// 84坐标
		String wkt84 = "POLYGON ((114.1857961792887 30.475180451015717, 114.18722305359552 30.475167866821753, 114.18722418854787 30.474048443786153, 114.18579731445774 30.474061028021012, 114.1857961792887 30.475180451015717))";
		// 百度坐标
		String wktBaidu = "POLYGON ((114.197879 30.47845, 114.199298 30.47845, 114.199298 30.47733, 114.197879 30.47733, 114.197879 30.47845))";
		System.out.println(GeotoolsUtils.withInGeo(114.1867961792887, 30.475170451015717, wkt84));
		
		
//		changePoint("route", "114.059942,30.944065;114.05563,30.931427", 50);
		
//		GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
//		Geometry a=gf.createPoint(new Coordinate(114.3127359726332,30.596477153683676));
//		
//		int distance=8238;
//		String tt=createBuffer(a.toString(), distance);
//		System.out.println(tt);
//		
//		
//		 JSONObject areaJson = new JSONObject(wktToJson(tt, null));
//		System.out.println(areaJson);
		
//		String line="114.19546290116477,30.638032948647314;114.13792520006005,30.579512411002874;114.20649324961055,30.545885404009578;114.26461734570066,30.636421619635414";
//		String py="114.01078929739063,30.62393478161024;114.31354716313778,30.624311403240384;114.31358014532267,30.551938153046137;114.0108220994436,30.551561474224243;114.01078929739063,30.62393478161024";
//		
//		System.out.println(changePoint("233",py));
		
		
		  
//		List list=new ArrayList<>();
//		list.add(new Coordinate(114.355337061964661, 25.473019331992273));
//		list.add(new Coordinate(114.460986089648614, 25.47481608416377));
//		list.add(new Coordinate(114.47176660267759, 25.380306919943092));
//		list.add(new Coordinate(114.460986089648614, 25.47481608416377));
//		list.add(new Coordinate(114.357133814136162, 25.377791466902995));
//		list.add(new Coordinate(114.355337061964661, 25.473019331992273));
//		Coordinate[] coordinates =(Coordinate[]) list.toArray(new Coordinate[list.size()]); 
//
//		 GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
//	     Geometry g1 = gf.createPolygon(coordinates);
		
		
		
//		String areaGeometry="POLYGON ((113.13632802012539 22.777880027299005, 113.13413630367558 22.77775133488739, 113.13199838609394 22.777311394585738, 113.12996701783051 22.776570416793327, 113.12809229920641 22.77554601638488, 113.12642043140598 22.774262874152388, 113.12499257419952 22.772752187128738, 113.1238438393294 22.771050914495703, 113.1230024420654 22.769200843240966, 113.12248902723955 22.767247511362225, 113.12231618081411 22.76523903392439, 113.1224881339631 22.763224878395345, 113.1230006635988 22.761254631577902, 113.12384119083418 22.759376792875134, 113.12498907655541 22.757637619389687, 113.12641611058638 22.756080039254645, 113.12808718747297 22.754742642491657, 113.12996115742726 22.753658755439453, 113.13199183543577 22.75285560667726, 113.13412914526262 22.752353599266574, 113.13632036877733 22.75216571392119, 113.13851146571348 22.752297076471542, 113.14064842563718 22.752744726303014, 113.14267861322894 22.753497617320292, 113.14455206995272 22.754536869367435, 113.14622273909882 22.755836269028745, 113.14764958593697 22.75736299931514, 113.14879758924322 22.75907856257005, 113.14963858417772 22.760939852548862, 113.1501519394169 22.762900329841045, 113.15032505407 22.7649112574101, 113.15015366288658 22.766922957275032, 113.14964194200826 22.768886053313707, 113.1488024120697 22.77075266838188, 113.14765564044271 22.772477547258223, 113.14622974928207 22.77401908168036, 113.14455974030749 22.775340220722672, 113.14268665081097 22.776409258428522, 113.14065655850689 22.77720049887608, 113.1385194560796 22.777694803817, 113.13632802012539 22.777880027299005))";
//		String wkt = "POLYGON((116.400674666119 39.9263885185624, 116.401888188937 39.9264653251907, 116.40191458308 39.9264644052923, 116.401940292158 39.9264583604362, 116.401964330764 39.9264474223171, 116.401985777516 39.9264320101843, 116.402003810378 39.9264127147726, 116.402017738163 39.9263902756596, 116.402027027033 39.9263655529186, 116.40203132095 39.9263394941527, 116.402030455334 39.9263130981735, 116.402024463362 39.9262873767178, 116.402013574702 39.9262633156685, 116.401998206708 39.9262418372665, 116.401978948422 39.9262237647616, 116.401956537999 39.9262097908587, 116.40106401173 39.9257681388544, 116.401051733527 39.9257628043095, 116.400404099472 39.9255188647991, 116.400505604522 39.9248155672974, 116.401509496117 39.9243582356005, 116.40243885151 39.9248543923779, 116.402465636555 39.9248651880585, 116.402494105672 39.9248700352012, 116.402522954132 39.9248687116633, 116.402550859822 39.924861278102, 116.403475276474 39.9245053012346, 116.403497541963 39.9244942752836, 116.403517407624 39.9244793528484, 116.403534199546 39.9244610401499, 116.403547348088 39.9244399584184, 116.403556407207 39.9244168228194, 116.403843308278 39.9234228101547, 116.403847986699 39.9233982388045, 116.403848048309 39.9233732261063, 116.403843490991 39.923348632007, 116.403834471427 39.9233253020621, 116.403821299713 39.9233040383648, 116.403804428699 39.9232855719698, 116.403784438416 39.9232705377596, 116.402748469322 39.9226325464784, 116.402721950409 39.9226199653268, 116.402693338013 39.9226134178896, 116.40266398675 39.9226132141466, 116.402635286217 39.9226193637436, 116.401474467165 39.9230041562204, 116.400920447672 39.9221612172532, 116.401590555625 39.9214491318185, 116.403076167372 39.9218107966693, 116.403078237002 39.9218112832672, 116.404548044731 39.9221446544492, 116.405012918123 39.922698819402, 116.40502272931 39.9227093236039, 116.405596494575 39.9232614675574, 116.405618403578 39.9232785761712, 116.405643354131 39.9232908309238, 116.405670286777 39.9232977114504, 116.405698057893 39.923298925588, 116.405725488256 39.9232944217816, 116.405751413108 39.9232843912732, 116.405774731621 39.923269259981, 116.405794453638 39.9232496704145, 116.405809741716 39.9232264543915, 116.406198836619 39.9224774684664, 116.407366491618 39.9229647496328, 116.407869630367 39.9237981730909, 116.40788545081 39.923819363529, 116.407905101317 39.9238370603836, 116.40792782673 39.9238505835743, 116.407952753724 39.9238594134126, 116.407978924369 39.9238632105727, 116.408005332941 39.9238618291319, 116.408030964575 39.9238553221782, 116.40805483426 39.9238439397702, 116.408076024698 39.9238281193274, 116.408093721552 39.9238084688205, 116.408107244743 39.9237857434076, 116.408116074581 39.9237608164135, 116.408119871742 39.9237346457686, 116.408118490301 39.9237082371961, 116.408111983347 39.9236826055626, 116.408100600939 39.9236587358775, 116.407574655101 39.9227875336489, 116.407557513222 39.9227649153201, 116.407536018611 39.9227463838742, 116.40751112263 39.9227327595232, 116.406188265551 39.9221807100386, 116.406164363285 39.9221732531514, 116.406139494649 39.922170342062, 116.406114516394 39.9221720770603, 116.406090289044 39.9221783983738, 116.406067647257 39.9221890882269, 116.406047371065 39.9222037783434, 116.406030159003 39.9222219626338, 116.406016604045 39.9222430146311, 116.405653525847 39.9229419198536, 116.405214992009 39.9225199113742, 116.404725543239 39.9219364506747, 116.404704497705 39.9219162666766, 116.404679606383 39.9219010768651, 116.404652032359 39.9218915910078, 116.403138951249 39.9215484048697, 116.401578054392 39.9211684122304, 116.401549907571 39.9211646366172, 116.401521594041 39.9211668372509, 116.401494368632 39.9211749166013, 116.401469437951 39.9211885165986, 116.401447906903 39.9212070345029, 116.400650990909 39.9220538715975, 116.400635232264 39.9220741942662, 116.400623616593 39.9220971381535, 116.400616566041 39.9221218694188, 116.400614336842 39.9221474892636, 116.400617010012 39.922173066596, 116.400624488401 39.9221976718693, 116.400636500224 39.9222204108638, 116.401305885269 39.9232388781657, 116.401321630765 39.9232585502398, 116.401340760038 39.9232749509119, 116.401362605669 39.9232875079634, 116.401386405465 39.9232957832794, 116.401411329052 39.9232994881344, 116.401436506848 39.9232984932663, 116.401461060399 39.923292833386, 116.40266051413 39.9228952341467, 116.403555660688 39.923446501267, 116.40331577779 39.9242776122771, 116.402511484911 39.9245873315564, 116.401577759661 39.9240888418346, 116.401554969815 39.9240792442379, 116.401530810931 39.9240739679419, 116.40150609482 39.9240731902459, 116.401481652015 39.9240769372827, 116.401458303869 39.9240850831408, 116.400326692383 39.9246005987639, 116.400303418694 39.9246141561161, 116.40028330233 39.9246320669588, 116.400267145254 39.924653617255, 116.400255591586 39.9246779478765, 116.400249101928 39.9247040888541, 116.400121583912 39.9255876222476, 116.400120369609 39.9256136446509, 116.400124179754 39.925639415231, 116.400132872256 39.9256639729267, 116.400146122945 39.9256864019088, 116.400163437664 39.925705865734, 116.400184170697 39.9257216385386, 116.400207548846 39.9257331321081, 116.400950362131 39.9260129220724, 116.401234714004 39.9261536289388, 116.400550494877 39.9261103231489, 116.40052326896 39.926111356868, 116.400496806061 39.9261178402386, 116.400472185662 39.9261295087891, 116.400450412085 39.9261458865327, 116.400432373524 39.9261663053836, 116.400418805814 39.9261899324103, 116.400410262413 39.9262158038122, 116.400407091826 39.9262428642355, 116.400391137394 39.9272736142777, 116.400393321812 39.9272999685828, 116.400400605727 39.9273253903385, 116.400412709222 39.927348902601, 116.400429167167 39.9273696018072, 116.400449347091 39.9273866924982, 116.400472473493 39.9273995178884, 116.400497657637 39.9274075851052, 116.40052393171 39.9274105841299, 116.400550286015 39.9274083997119, 116.400575707771 39.9274011157969, 116.400599220033 39.9273890123018, 116.400619919239 39.9273725543571, 116.40063700993 39.9273523744324, 116.400649835321 39.9273292480309, 116.400657902537 39.9273040638872, 116.400660901562 39.9272777898139, 116.400674666119 39.9263885185624))";
//		

	
		

//		GeometryJSON gJson = new GeometryJSON();
//	       Reader reader = new StringReader(wkt);
//	       Geometry geo=gJson.read(reader);
//	       System.out.println(geo);
		
		String wkt = "POLYGON((116.400674666119 39.9263885185624, 116.401888188937 39.9264653251907, 116.40191458308 39.9264644052923, 116.401940292158 39.9264583604362, 116.401964330764 39.9264474223171, 116.401985777516 39.9264320101843, 116.402003810378 39.9264127147726, 116.402017738163 39.9263902756596, 116.402027027033 39.9263655529186, 116.40203132095 39.9263394941527, 116.402030455334 39.9263130981735, 116.402024463362 39.9262873767178, 116.402013574702 39.9262633156685, 116.401998206708 39.9262418372665, 116.401978948422 39.9262237647616, 116.401956537999 39.9262097908587, 116.40106401173 39.9257681388544, 116.401051733527 39.9257628043095, 116.400404099472 39.9255188647991, 116.400505604522 39.9248155672974, 116.401509496117 39.9243582356005, 116.40243885151 39.9248543923779, 116.402465636555 39.9248651880585, 116.402494105672 39.9248700352012, 116.402522954132 39.9248687116633, 116.402550859822 39.924861278102, 116.403475276474 39.9245053012346, 116.403497541963 39.9244942752836, 116.403517407624 39.9244793528484, 116.403534199546 39.9244610401499, 116.403547348088 39.9244399584184, 116.403556407207 39.9244168228194, 116.403843308278 39.9234228101547, 116.403847986699 39.9233982388045, 116.403848048309 39.9233732261063, 116.403843490991 39.923348632007, 116.403834471427 39.9233253020621, 116.403821299713 39.9233040383648, 116.403804428699 39.9232855719698, 116.403784438416 39.9232705377596, 116.402748469322 39.9226325464784, 116.402721950409 39.9226199653268, 116.402693338013 39.9226134178896, 116.40266398675 39.9226132141466, 116.402635286217 39.9226193637436, 116.401474467165 39.9230041562204, 116.400920447672 39.9221612172532, 116.401590555625 39.9214491318185, 116.403076167372 39.9218107966693, 116.403078237002 39.9218112832672, 116.404548044731 39.9221446544492, 116.405012918123 39.922698819402, 116.40502272931 39.9227093236039, 116.405596494575 39.9232614675574, 116.405618403578 39.9232785761712, 116.405643354131 39.9232908309238, 116.405670286777 39.9232977114504, 116.405698057893 39.923298925588, 116.405725488256 39.9232944217816, 116.405751413108 39.9232843912732, 116.405774731621 39.923269259981, 116.405794453638 39.9232496704145, 116.405809741716 39.9232264543915, 116.406198836619 39.9224774684664, 116.407366491618 39.9229647496328, 116.407869630367 39.9237981730909, 116.40788545081 39.923819363529, 116.407905101317 39.9238370603836, 116.40792782673 39.9238505835743, 116.407952753724 39.9238594134126, 116.407978924369 39.9238632105727, 116.408005332941 39.9238618291319, 116.408030964575 39.9238553221782, 116.40805483426 39.9238439397702, 116.408076024698 39.9238281193274, 116.408093721552 39.9238084688205, 116.408107244743 39.9237857434076, 116.408116074581 39.9237608164135, 116.408119871742 39.9237346457686, 116.408118490301 39.9237082371961, 116.408111983347 39.9236826055626, 116.408100600939 39.9236587358775, 116.407574655101 39.9227875336489, 116.407557513222 39.9227649153201, 116.407536018611 39.9227463838742, 116.40751112263 39.9227327595232, 116.406188265551 39.9221807100386, 116.406164363285 39.9221732531514, 116.406139494649 39.922170342062, 116.406114516394 39.9221720770603, 116.406090289044 39.9221783983738, 116.406067647257 39.9221890882269, 116.406047371065 39.9222037783434, 116.406030159003 39.9222219626338, 116.406016604045 39.9222430146311, 116.405653525847 39.9229419198536, 116.405214992009 39.9225199113742, 116.404725543239 39.9219364506747, 116.404704497705 39.9219162666766, 116.404679606383 39.9219010768651, 116.404652032359 39.9218915910078, 116.403138951249 39.9215484048697, 116.401578054392 39.9211684122304, 116.401549907571 39.9211646366172, 116.401521594041 39.9211668372509, 116.401494368632 39.9211749166013, 116.401469437951 39.9211885165986, 116.401447906903 39.9212070345029, 116.400650990909 39.9220538715975, 116.400635232264 39.9220741942662, 116.400623616593 39.9220971381535, 116.400616566041 39.9221218694188, 116.400614336842 39.9221474892636, 116.400617010012 39.922173066596, 116.400624488401 39.9221976718693, 116.400636500224 39.9222204108638, 116.401305885269 39.9232388781657, 116.401321630765 39.9232585502398, 116.401340760038 39.9232749509119, 116.401362605669 39.9232875079634, 116.401386405465 39.9232957832794, 116.401411329052 39.9232994881344, 116.401436506848 39.9232984932663, 116.401461060399 39.923292833386, 116.40266051413 39.9228952341467, 116.403555660688 39.923446501267, 116.40331577779 39.9242776122771, 116.402511484911 39.9245873315564, 116.401577759661 39.9240888418346, 116.401554969815 39.9240792442379, 116.401530810931 39.9240739679419, 116.40150609482 39.9240731902459, 116.401481652015 39.9240769372827, 116.401458303869 39.9240850831408, 116.400326692383 39.9246005987639, 116.400303418694 39.9246141561161, 116.40028330233 39.9246320669588, 116.400267145254 39.924653617255, 116.400255591586 39.9246779478765, 116.400249101928 39.9247040888541, 116.400121583912 39.9255876222476, 116.400120369609 39.9256136446509, 116.400124179754 39.925639415231, 116.400132872256 39.9256639729267, 116.400146122945 39.9256864019088, 116.400163437664 39.925705865734, 116.400184170697 39.9257216385386, 116.400207548846 39.9257331321081, 116.400950362131 39.9260129220724, 116.401234714004 39.9261536289388, 116.400550494877 39.9261103231489, 116.40052326896 39.926111356868, 116.400496806061 39.9261178402386, 116.400472185662 39.9261295087891, 116.400450412085 39.9261458865327, 116.400432373524 39.9261663053836, 116.400418805814 39.9261899324103, 116.400410262413 39.9262158038122, 116.400407091826 39.9262428642355, 116.400391137394 39.9272736142777, 116.400393321812 39.9272999685828, 116.400400605727 39.9273253903385, 116.400412709222 39.927348902601, 116.400429167167 39.9273696018072, 116.400449347091 39.9273866924982, 116.400472473493 39.9273995178884, 116.400497657637 39.9274075851052, 116.40052393171 39.9274105841299, 116.400550286015 39.9274083997119, 116.400575707771 39.9274011157969, 116.400599220033 39.9273890123018, 116.400619919239 39.9273725543571, 116.40063700993 39.9273523744324, 116.400649835321 39.9273292480309, 116.400657902537 39.9273040638872, 116.400660901562 39.9272777898139, 116.400674666119 39.9263885185624))";
		Boolean a = GeotoolsUtils.withInGeo(116.40301731682695, 39.921436321582945, wkt);
		System.out.println("withIn:" + a);
//		
//		String line = "LINESTRING(116.400526019478 39.9272757020458, 116.40054197391 39.9262449520036, 116.401896709904 39.926330696336, 116.401004183635 39.9258890443317, 116.400255098738 39.925606892086, 116.400382616754 39.9247233586925, 116.40151422824 39.9242078430694, 116.402502382931 39.9247353911431, 116.403426799583 39.9243794142757, 116.403713700654 39.923385401611, 116.40267773156 39.9227474103298, 116.401418615056 39.9231647867998, 116.400749230011 39.9221463194979, 116.401546146005 39.9212994824033, 116.403108075759 39.9216797264964, 116.404622193602 39.9220231477786, 116.40511626776 39.9226121222981, 116.405690033025 39.9231642662516, 116.406136312736 39.922305202771, 116.407459169815 39.9228572522556, 116.407985115653 39.9237284544842)";
//		String buffer = GeotoolsUtils.createBuffer(line, 15);
//		System.out.println("============" + buffer);
//		
//		String wktPoly = "POLYGON ((0 0, 0 10, 10 20, 20 20, 20 0, 0 0))";
//		System.out.println(GeotoolsUtils.withInGeo(21, 10, wktPoly));
		
		

//		System.out.println(geometry.getCoordinates().toString());
//		
//		for(Coordinate pos:geometry.getCoordinates()){
//			System.out.println(pos.toString());
//			
//		}
//		System.out.println(getfz(geometry.getCoordinates()));
		
		
//		JSONObject json=JSONObject.parseObject(geoJson);
//		String coordinatesStr=json.get("coordinates").toString();
//		String sub=coordinatesStr.replace("[[[", "[[").replace("]]]", "]]");
//		List list=(List) JSONArray.parse(sub);
//		System.out.println(getfz(list));
//		List<GeoPoint> points=getfz(list);
//		
//		List pointList=new ArrayList<>();
//		
//		for (GeoPoint ob : points) {
//			pointList.add(new Coordinate(ob.getX(),ob.getY()));
//		}
//		Coordinate[] coordinates =(Coordinate[]) pointList.toArray(new Coordinate[points.size()]); 
//		
//		GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
//		Geometry g1=gf.createLineString(coordinates);


//		
//		List points=new ArrayList<>();
//		points.add(new Coordinate(114.355337061964661, 25.473019331992273));
//		points.add(new Coordinate(114.460986089648614, 25.47481608416377));
//		points.add(new Coordinate(114.47176660267759, 25.380306919943092));
//		points.add(new Coordinate(114.460986089648614, 25.47481608416377));
//		points.add(new Coordinate(114.357133814136162, 25.377791466902995));
//		points.add(new Coordinate(114.355337061964661, 25.473019331992273));
//		Coordinate[] coordinates =(Coordinate[]) points.toArray(new Coordinate[points.size()]); 
//
//		 GeometryFactory gf = JTSFactoryFinder.getGeometryFactory( null );
//	     Geometry g1 = gf.createPolygon(coordinates);
//	    System.out.println(g1);
	//	System.out.println(baidug84tobd(null, null, "114.355337061964661,25.473019331992273"));//{"x":114.34888149513354,"y":25.466728938510067}
	
//		System.out.println(baidtohx("113.4088134186055,22.610214741412204"));//[{"x":113.40236630619137,"y":22.60387415137693}]}
		
//		double[] a=GPSUtil.gcj02towgs84(113.40236630619137,22.60387415137693); //113.39687712197977,22.606553798575607
//		System.out.println(a[0]+","+a[1]);
	
		
	}

	
}
