package com.inzyme.spatiotemporal.common.utils;

import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import com.sun.crypto.provider.SunJCE;

/**
 * @ClassName: DES3
 * @Description: 3DES加密解密算法
 * @date 2018年10月30日 上午11:44:42
 * @author Q.JI
 * @version
 * @since JDK 1.7
 */


/**
 *
 * @ClassName: DES3
 * @Description: 3DES加密解密算法
 * @date 2022年7月4日 下午4:51:59    
 *
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
public class DES3 {

    /** 定义 加密算法,可用 DES,DESede,Blowfish */
    private static final String Algorithm = "DESede";

    /** 24字节的密钥 定义 */
    private static final byte[] keyBytes = {0x11, 0x22, 0x4F, 0x58,
            (byte) 0x88, 0x10, 0x40, 0x38, 0x28, 0x25, 0x79, 0x51, (byte) 0xCB,
            (byte) 0xDD, 0x55, 0x66, 0x77, 0x29, 0x74, (byte) 0x98, 0x30, 0x40,
            0x36, (byte) 0xE2};

    /**
     *
     * @Title: encode
     * @Description: 对字符串进行3DES算法加密
     * @param str    需要加密的字符串
     * @return 加密后的字符串
     * String
     */
    public static String encode(String str) {
        Security.addProvider(new SunJCE());
        byte[] encoded = encryptMode(keyBytes, str.getBytes());
        return byteHEX(encoded);
    }

    public static String parseByte2HexStr(byte buf[]) {

        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < buf.length; i++) {

            String hex = Integer.toHexString(buf[i] & 0xFF);

            if (hex.length() == 1) {

                hex = '0' + hex;

            }

            sb.append(hex.toUpperCase());

        }

        return sb.toString();

    }


    /**
     *
     * @Title: decode
     * @Description: 解密字符串
     * @param des3Str    已加密的字符串
     * @return 源字符串
     * String
     */
    public static String decode(String des3Str) {
        Security.addProvider(new SunJCE());
        System.out.println(parseByte2HexStr(keyBytes));
        byte[] srcBytes = decryptMode(keyBytes, HexString2Bytes(des3Str));
        if (null != srcBytes) {
			return new String(srcBytes);
		} else {
			return "";
		}
    }

    /**
     *
     * @Title: encryptMode
     * @Description: 对字符串进行3DES加密
     * @param keybyte
     *            keybyte 为加密密钥，长度为24字节
     * @param src
     *            src 被加密的数据缓冲区（源）
     * @return byte[]
     */
    private static byte[] encryptMode(byte[] keybyte, byte[] src) {
        try {
            // 生成密钥
            SecretKey deskey = new SecretKeySpec(keybyte, Algorithm);

            // 加密
            Cipher c1 = Cipher.getInstance(Algorithm);
            c1.init(Cipher.ENCRYPT_MODE, deskey);
            return c1.doFinal(src);
        } catch (java.security.NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        } catch (javax.crypto.NoSuchPaddingException e2) {
            e2.printStackTrace();
        } catch (java.lang.Exception e3) {
            e3.printStackTrace();
        }
        return null;
    }

    /**
     *
     * @Title: decryptMode
     * @Description: 对字符串进行3DES解密
     * @param keybyte
     *            keybyte 为加密密钥，长度为24字节
     * @param src
     *            加密后的缓冲区
     * @return byte[]
     */
    private static byte[] decryptMode(byte[] keybyte, byte[] src) {
        try {
            // 生成密钥
            SecretKey deskey = new SecretKeySpec(keybyte, Algorithm);

            // 解密
            Cipher c1 = Cipher.getInstance(Algorithm);
            c1.init(Cipher.DECRYPT_MODE, deskey);
            return c1.doFinal(src);
        } catch (java.security.NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        } catch (javax.crypto.NoSuchPaddingException e2) {
            e2.printStackTrace();
        } catch (java.lang.Exception e3) {
            e3.printStackTrace();
        }
        return null;
    }


    /**
     *
     * @Title: byteHEX
     * @Description: 用来把一个byte类型的数转换成十六进制的ASCII
     * @param ib
     * @return
     * String
     */
    private static String byteHEX(byte ib) {
        char[] Digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A',
                'B', 'C', 'D', 'E', 'F'};
        char[] ob = new char[2];
        ob[0] = Digit[(ib >>> 4) & 0X0F];
        ob[1] = Digit[ib & 0X0F];
        String s = new String(ob);
        return s;
    }


    /**
     *
     * @Title: byteHEX
     * @Description: byteHEX()，用来把一个byte类型的数转换成十六进制的ASCII表示
     * @param ib
     * @return
     * String
     */
    private static String byteHEX(byte[] ib) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < ib.length; i++) {
            str.append(byteHEX(ib[i]));
        }
        return str.toString();
    }


    /**
     *
     * @Title: encrypt3DES
     * @Description: 对字符串进行3DES算法加密
     * @param str    需要加密的字符串
     * @param keyBytes    24字节的密钥
     * @return
     * String
     */
    private static String encrypt3DES(String str, byte[] keyBytes) {
        Security.addProvider(new SunJCE());
        byte[] encoded = encryptMode(keyBytes, str.getBytes());
        return byteHEX(encoded);
    }


    /**
     *
     * @Title: decrypt3DES
     * @Description: 解密字符串
     * @param des3Str    已加密的字符串
     * @param keyBytes    24字节的密钥
     * @return
     * String
     */
    private static String decrypt3DES(String des3Str, byte[] keyBytes) {
        Security.addProvider(new SunJCE());
        byte[] srcBytes = decryptMode(keyBytes, HexString2Bytes(des3Str));
        if (null != srcBytes) {
			return new String(srcBytes);
		} else {
			return "";
		}
    }

    /**
     *
     * @Title: uniteBytes
     * @Description: 联结byte
     * @param src0
     * @param src1
     * @return
     * byte
     */
    private static byte uniteBytes(byte src0, byte src1) {
        byte _b0 = Byte.decode("0x" + new String(new byte[]{src0})).byteValue();
        _b0 = (byte) (_b0 << 4);
        byte _b1 = Byte.decode("0x" + new String(new byte[]{src1})).byteValue();
        byte ret = (byte) (_b0 | _b1);
        return ret;
    }


    /**
     *
     * @Title: HexString2Bytes
     * @Description: 将16进制字符串转化为byte数组
     * @param src    16进制字符串
     * @return
     * byte[]
     */
    private static byte[] HexString2Bytes(String src) {
        byte[] ret = new byte[src.length() / 2];
        byte[] tmp = src.getBytes();
        for (int i = 0; i < src.length() / 2; ++i) {
            ret[i] = uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
        }
        return ret;
    }


    public static void main(String[] args) {
//		String a = "{\"username\":\"zhangsan\",\"realname\":\"张三\",\"password\":\"123456\"}";
//		SysUserEntity user1 = JSONUtils.jsonToBean(a, SysUserEntity.class);		

//		String str1 = "{\"userID\":264,\"object\":{\"userId\":null,\"orgId\":null,\"orgName\":null,\"username\":\"zhangsan\",\"realname\":\"张三\",\"password\":\"123456\",\"email\":null,\"mobile\":null,\"status\":null,\"userIdCreate\":null,\"remark\":null,\"gmtCreate\":null,\"gmtModified\":null,\"roleIdList\":null}}";
//		String str = "{\"userID\":264,\"object\":{\"username\":\"zhangsan\",\"realname\":\"张三\",\"password\":\"123456\"}}";

//        RequestParam<NoticeDetailReqVo> reqParam = new RequestParam<NoticeDetailReqVo>();
//        reqParam.setAccountId("123456");
        //Map<String, Object> dataMap = new HashMap<String, Object>();
//		dataMap.put("enterpriseName", "abc");
//        NoticeDetailReqVo noticeDetailReqVo = new NoticeDetailReqVo();
//        noticeDetailReqVo.setNoticeId("88");
//        reqParam.setData(noticeDetailReqVo);
//        String str = JSONUtils.beanNoNullToJson(reqParam);

        String en = encode("{\n" +
                "  \"accountId\": \"string\",\n" +
                "  \"data\": \"1111\"\n" +
                "}");
       // en = StringEscapeUtils.unescapeJava(en);
        String de = decode("3afa77df83f1979996c2aa3d8d7fcb7c454a7ce89b1851d11fd93c77359af9aa8dc61f96ab25356e");
        System.out.println("密文：" + en);
       System.out.println("明文：" + de);
		/*
		try {
			RequestParam appParam = JSONUtils.jsonToBean(de, RequestParam.class);
			Map<String, Object> data = JSONUtils.convertValue(appParam.getData(), Map.class);
			System.out.println(data.get("enterpriseName"));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		
		ResultVO<Object> response = new ResultVO<>();		
		response.setMsg("success");
		response.setCode("0");
		
		List<UserInfo> list = new ArrayList<>();
		UserInfo sysuser = null;
		for(int i = 0; i < 5; i++) {
			sysuser = new UserInfo();
			sysuser.setUserId(new Long(i));
			sysuser.setFullname("username-" + i);
			list.add(sysuser);
		}		
		response.setData(list);
		
		String encode = DES3.encode(JSONUtils.beanToJson(response));
		System.out.println("encode:" + encode);
		
		String decode = DES3.decode(encode);		
		System.out.println("decode:" + decode);
		
		String encode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
		String decode1 = DES3.decode(encode1);		
		System.out.println("decode1:" + decode1);*/

//		String kk = decode("asdfoeg");	
//		System.out.println(kk);
//		System.out.println(decode("344BA77D8615F311F554AD54BF90FBD64A0CF370DEBB0C49200CD699C525D2381531FA7BCF088F7A01FB785C0BD805586E1FF83BAB72B32C30EBEBB52798BFFFC422041E113BF48A3E629C0ADD3437FABE5AC689164231256A455AC929E841655B3ADADAC958B9679F13A94892BBC0D7E51A895F97A61A85EDBAA3DB20801A9070B4616AA28DA6067D4DE7DFF77D15D8EA3A3CD2646E117E9824BC5D618FB1224E3E39C841C18BCF3E629C0ADD3437FA0BB3A1F3B55806CE3EF005B9B0EE44F347400B713665424A4320EE3B80D2EC7156E29841F8E25FEAA4255E43B3AF6B0063A0F046B7195DD0FF3FB11244EE79CA23AA0B7C72848BB7A17F5BA6193D9B1976ED40D0DEBC3CEEA8CF24B1306D60E05C1F460F48D25958E2ED7C33AD8BEA2FC600F0063CC12746"));
    }


}
