package com.inzyme.spatiotemporal.common.utils;

/**
 * @author yifan.wang
 * @date 
 */
public interface ConstantsRedis {
	
	/**
	 * 告警消息topic
	 */
	String ALARM_TOPIC = "ALARMMessages/Platform/A";
	
	/**
	 * 告警结束消息topic
	 */
	String ALARM_END_TOPIC = "ALARMENDMessages/Platform/A";
	
    /**
     * 车辆实时信息redisKey
     */
    String VEHICLE_REALINFO_KEY =  "com.inzyme.gps.realinfo";

    /**
     * 车辆信息信息redisKey
     */
    String VEHICLE_CFG_KEY =  "com.inzyme.gps.vehicle";
    
    /**
     * 异常配置策略redisKey (hash)
     */
    String CFG_EXCEPTION_LAYER_KEY =  "com.inzyme.gps.exception:";
    
    /**
     * 任务车辆信息redisKey (set)
     */
    String TASK_VEHICLE_CFG_KEY =  "com.inzyme.gps.task.vehicle";
    
    /**
     * 夜间行车初次告警(string)  TTL:3h
     */
    String VEHICLE_ALARM_DRIVING_NIGHT = "com.inzyme.gps.vehicle.night:";
    
    /**
     * 停车超时初次告警 (hash)	value = 初次告警时间
     */
    String VEHICLE_ALARM_PARKING = "com.inzyme.gps.vehicle.parking";
    
    
    /**
     * 线路偏移初次告警 (hash)	value = 初次告警时间
     */
    String VEHICLE_ALARM_OFFSET = "com.inzyme.gps.vehicle.offset";
    
    /**
     * 围栏(hash)   key:围栏ID
     */
    String CFG_MAPAREA = "com.inzyme.gps.maparea";


    /**
     * 方形rect围栏(hash)   key:围栏ID
     */
    String CFG_RECTMAPAREA = "com.inzyme.gps.rectmaparea";

    
    /**
     * 车辆-围栏绑定(hash)		key:plateNo
     */
    String CFG_VEHICLE_MAPAREA_BIND = "com.inzyme.gps.maparea.bind";
    
    /**
     * 各类已发生的告警
     * 无则新增，有则跳过 
     * 当检测到对应类型告警结束，删除该值 (hash) 
     */
    String ALARM_OCCURRED = "com.inzyme.gps.alarm:";

    /**
     * 城市天气信息(hash)
     */
    String CITY_WEATHER = "com.inzyme.gps.weather";
    
    /**
     * 	setkey: yyyymmdd:部门ID:时段		TTL:72h			value:该天该部门该时段下的车牌集合
     */
    String ONLINE_TIME_INTERVAL = "com.inzyme.gps.online:";

    /**
     * 任务车辆信息redisKey (运单号)
     */
    String TASK_VEHICLE_CFG_WAYBILL =  "com.inzyme.gps.task.vehicle:waybill";
    
    /**
     * 异常报备(string)  key:  plateNo:startDate|endDate,   value:  startDate, endDate   TTL: endDate-now()
     */
    String VEHICLE_ALARM_FILING = "com.inzyme.gps.task.vehicle.filing:";
    
}
