package com.inzyme.spatiotemporal.common.utils;

import java.util.*;

/**   
 * @ClassName: Constants   
 * @Description: 常量
 * @date 2023年2月14日 下午5:02:39    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
*/
public class ConstantsGps {	
	
	/**
     * MQTT 中英文字段对照
     */
	public static final Map<String, String> MQTTFIELDS = new HashMap<String, String>() {
		{
			put("设备编号", "deviceId");
			put("SIM卡号", "simNo");
			put("锁状态", "lockStatus");
			put("经度", "longitude");
			put("纬度", "latitude");
			put("高度", "high");
			put("速度", "velocity");
			put("方向", "direction");
			put("里程", "mileage");			
			put("电压", "voltage");
			put("定位时间", "sendTime");
			put("流水号", "serialNumber");
			put("消息ID", "messageId");
		}
	};
	
	
	/**
	 * 日报模板里的单行
	 */
	public static final List<Integer> SINGLELINE = new ArrayList<Integer>() {
		{
			add(11);
			add(12);
			add(13);
			add(14);
			add(25);
			add(26);
			add(52);
			add(53);
			add(62);
			add(63);
			add(72);
			add(73);
			add(84);
			add(85);
			add(91);
			add(92);
		}
	};
	
	
	/**
	 * 小时--时段对应关系
	 */
	public static final Map<Integer, Integer> TIME_INTERVAL = new HashMap<Integer, Integer>() {
		{
			put(0, 0);
			put(1, 0);
			put(2, 2);
			put(3, 2);
			put(4, 4);
			put(5, 4);
			put(6, 4);
			put(7, 4);
			put(8, 8);
			put(9, 8);
			put(10, 10);
			put(11, 10);
			put(12, 10);
			put(13, 13);
			put(14, 13);
			put(15, 15);
			put(16, 15);
			put(17, 17);
			put(18, 17);
			put(19, 17);
			put(20, 20);
			put(21, 20);
			put(22, 22);
			put(23, 22);
		}
	};	

}
