package com.inzyme.spatiotemporal.common.utils;


import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import lombok.extern.slf4j.Slf4j;


/**
 * @author hc
 * @version Id: CommunicationUtils.java , v0.1 2019年1月2日 Exp $
 *
 */
@Slf4j
public class CommunicationUtils {
	/**
	 * 连接超时时间,单位：毫秒
	 */
	private static int CONNECTION_TIME_OUT = 10000;
	/**
	 * 等待超时时间,单位：毫秒
	 */
	private static int READ_TIME_OUT = 300000;
	
	
	
	
	
	
	/**
	 * post方式请求服务器(https协议)
	 * 
	 * @param url
	 *            请求地址
	 * @param content
	 *            参数
	 * @param charset
	 *            编码
	 * @param flag
	 *            参数类型
	 * @param header    
	 *            请求头参数       
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws KeyManagementException
	 * @throws IOException
	 * @throws NoSuchProviderException
	 */
	public static String postHttps(String url, String content,
			Map<String,String> header) throws Exception {

		URL console = new URL(url);
		SSLContext sc = SSLContext.getInstance("SSL");
		sc.init(null, new TrustManager[] { new TrustAnyTrustManager() },
				new java.security.SecureRandom());
		HttpsURLConnection conn = (HttpsURLConnection) console.openConnection();
		conn.setSSLSocketFactory(sc.getSocketFactory());
		conn.setHostnameVerifier(new TrustAnyHostnameVerifier());
		// 读写属性
		conn.setDoOutput(true);
		conn.setDoInput(true);
		// 连接超时秒数
		conn.setConnectTimeout(CONNECTION_TIME_OUT);
		// 读取超时秒数
		conn.setReadTimeout(READ_TIME_OUT);
		// 请求方式
		conn.setRequestMethod("POST");
		conn.setDoInput(true);
		conn.setDoOutput(true);
		// 不使用缓存
		conn.setUseCaches(false);

		// (如果不设此项,在传送序列化对象时,当WEB服务默认的不是这种类型时可能抛java.io.EOFException)
		// conn.setRequestProperty("Content-type","application/x-java-serialized-object");
		 conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
	        conn.setRequestProperty("Accept", "application/json");
		 if(header!=null) {
	        	Iterator<String> it = header.keySet().iterator();
	        	while(it.hasNext()) {
	        		String key = it.next();
	        		conn.setRequestProperty(key, header.get(key));
	        	}
	        	
	     }
		conn.connect();
		DataOutputStream out = new DataOutputStream(conn.getOutputStream());
		out.write(content.getBytes("utf-8"));
		// 刷新、关闭
		out.flush();
		out.close();
		InputStream is = conn.getInputStream();
		InputStreamReader isr = new InputStreamReader(is, "utf-8");
		if (is != null) {
			StringBuffer temp = new StringBuffer();
			int len = 0;
			while ((len = isr.read()) != -1) {
				temp.append((char) len);
			}
			isr.close();
			is.close();
			
			return	temp.toString();
		}
		return null;
	}
	
	
    
   
	
	
	/**
	 * 
	 * @param url
	 * @param content
	 * @param charset
	 * @param flag
	 * @param tag
	 * @param header
	 * @return
	 * @throws IOException
	 */
    public static String postHttp(String url, String content,Map<String,String> header) throws IOException {

        URL console = new URL(url);
        HttpURLConnection conn = (HttpURLConnection) console.openConnection();
        // 读写属性
        conn.setDoOutput(true);
        conn.setDoInput(true);
        // 连接超时秒数
        conn.setConnectTimeout(CONNECTION_TIME_OUT);
        // 读取超时秒数
        conn.setReadTimeout(READ_TIME_OUT);
        // 请求方式
        conn.setRequestMethod("POST");
        // 不使用缓存
        conn.setUseCaches(false);
        // (如果不设此项,在传送序列化对象时,当WEB服务默认的不是这种类型时可能抛java.io.EOFException)
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        
        if(header!=null) {
        	Iterator<String> it = header.keySet().iterator();
        	while(it.hasNext()) {
        		String key = it.next();
        		conn.setRequestProperty(key, header.get(key));
        	}
        	
        }
        
        
        conn.connect();
        
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        if (content != null) {
            out.write(content.getBytes("UTF-8"));
        }
        // 刷新、关闭
        
        out.flush();
        out.close();
        int code = conn.getResponseCode();
        InputStream is = conn.getInputStream();
    	InputStreamReader isr=null;
    	
    	
    	isr = new InputStreamReader(is,"UTF-8");
      
        
        log.info("InputStreamReader encoding:::{}",isr.getEncoding());
        if (is != null) {
            StringBuilder temp = new StringBuilder();
            int len;
            while ((len = isr.read()) != -1) {
                temp.append((char) len);
            }
            isr.close();
            is.close();
            return	temp.toString();
        }
        return null;
    }
    
    
    
    

    
    

	private static class TrustAnyTrustManager implements X509TrustManager {
		public void checkClientTrusted(X509Certificate[] chain, String authType)
				throws CertificateException {
		}

		public void checkServerTrusted(X509Certificate[] chain, String authType)
				throws CertificateException {
		}

		public X509Certificate[] getAcceptedIssuers() {
			return new X509Certificate[] {};
		}
	}

	private static class TrustAnyHostnameVerifier implements HostnameVerifier {
		public boolean verify(String hostname, SSLSession session) {
			return true;
		}
	}
	
	public static byte[] getUTF8BytesFromGBKString(String gbkStr) {
	    int n = gbkStr.length();
	    byte[] utfBytes = new byte[3 * n];
	    int k = 0;
	    for (int i = 0; i < n; i++) {
	        int m = gbkStr.charAt(i);
	        if (m < 128 && m >= 0) {
	            utfBytes[k++] = (byte) m;
	            continue;
	        }
	        utfBytes[k++] = (byte) (0xe0 | (m >> 12));
	        utfBytes[k++] = (byte) (0x80 | ((m >> 6) & 0x3f));
	        utfBytes[k++] = (byte) (0x80 | (m & 0x3f));
	    }
	    if (k < utfBytes.length) {
	        byte[] tmp = new byte[k];
	        System.arraycopy(utfBytes, 0, tmp, 0, k);
	        return tmp;
	    }
	    return utfBytes;
	}
	
	public static void main(String [] args) throws Exception {
//		String content = "[{\"accountNo\":\"6223250011321931\",\"ageUnit\":\"月\",\"amount\":\"\",\"bank\":\"汉口银行\",\"batchNo\":\"123\",\"cdbm\":\"\",\"clauseCode\":\"140954\",\"comCode\":\"42000000\",\"comName\":\"42000000\",\"groupNo\":1,\"gzqydm\":\"420102016200\",\"gzqymc\":\"武汉市江岸区谌家矶街道谌家矶街新建村\",\"id\":\"809\",\"identifyCode\":\"73747589\",\"identifyNumber\":\"420106198212274475\",\"identifyType\":\"01\",\"insuredAddress\":\"武汉\",\"insuredName\":\"刘松\",\"itemAge\":12,\"itemName\":\"能繁母猪\",\"itemdetailName\":\"能繁母猪\",\"mobilePhone\":\"13995610220\",\"operatorCode\":\"A420000035\",\"operatorName\":\"13666666643\",\"policypoolFarmerFlag\":\"\",\"premium\":\"\",\"quantity\":1,\"raiseSite\":\"武汉市江岸区谌家矶街道谌家矶街新建村\",\"rate\":6,\"remark\":\"\",\"riskCode\":\"IG3\",\"slaughterCount\":0,\"slaughterTime\":\"\",\"unit\":\"望\",\"unitAmount\":1500}]";
//		try {
//			postHttp("http://192.168.60.245:9000/agriins/WapGsHListImportServlet", content, Constant.GBK, Constant.REQ_PROPERTIES_JSON, Constant.OTHER_TAG);
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
		Map<String,String> header = new HashMap<String,String>();
		header.put("systemid", "s04");
		header.put("domain", "s04");
		String url =" https://综合集成平台访问地址/interfaces/verify";
		String content = "{\r\n" + 
				"\"type\":\"add\",\r\n" + 
				"\"users\":[\r\n" + 
				"    {\"username\":\"huangml\",\"nickname\":\"hml\",\"password\":\"123456\",\"orgName\":\"云南省档案馆\"},\r\n" + 
				"    {\"username\":\"zhangQ\",\"nickname\":\"zq\",\"password\":\"123456\",\"orgName\":\"云南省档案馆\"}\r\n" + 
				"    ]\r\n" + 
				"}";
		
		postHttps("https://IP:port/interfaces/syncuser", content,header);
		
		postHttp("https://IP:port/interfaces/syncuser", content,header);
		
		
	}
	

}
