package com.inzyme.spatiotemporal.common.utils;

/**
 * 编码工具类
 * 用于组织机构自动编码等
 * @author marquis
 *
 */
public class CodeUtils {
	
	/**
	 * 截取真是编码最后两位，获得当前层级的编码值
	 * @param code
	 * @return
	 */
	public static int getSubCode(String code) {
		String subCode = code.substring(code.length() - 2, code.length());
		return Integer.parseInt(subCode, 16);
	}

	/**
	 * 生成同级编码
	 * @param code
	 * @return
	 */
	public static String generateSameLevelCode(String code) {
		String parentCode = code.substring(0, code.length() - 2);
		int subCode = getSubCode(code) + 1;
		return String.format("%s%02x", parentCode, subCode);
	}

	/**
	 * 生成下级编码
	 * @param parentCode
	 * @return
	 */
	public static String generateNextLevelCode(String parentCode) {
		return String.format("%s%02x", parentCode, 1);
	}
}
