package com.inzyme.spatiotemporal.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;

public class ChineseCharToEn {
    
	/**
	 * 得到中文首字母（中国 -> ZG）
	 * @param str 需要转化的中文字符串
	 * @return 大写首字母缩写的字符串
	 */
	public static String getPinYinHeadChar(String str) {
		StringBuilder convert = new StringBuilder();
		if (StringUtils.isBlank(str)) {
			return "";
		}
		for (int j = 0; j < str.length(); j++) {
			char word = str.charAt(j);
			String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(word);
			if (pinyinArray != null) {
				convert.append(pinyinArray[0].charAt(0));
			} else {
				convert.append(word);
			}
		}
		return convert.toString().toUpperCase();
	}
}
