package com.inzyme.spatiotemporal.common.utils;


import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;

public class AesUtils {
       
	/**
     * 加解密统一编码方式
     */
    private final static String ENCODING = "utf-8";

    /**
     * 加解密方式
     */
    private final static String ALGORITHM  = "AES";

    /**
     *加密模式及填充方式
     */
    private final static String PATTERN = "AES/ECB/pkcs5padding";
    

    /**
     * AES加密
     * @param plainText
     * @param key
     * @return
     * @throws Exception
     */
    public static String encrypt(String content, String key) throws Exception {
    	   // 判断Key是否为16位
        if (key.length() != 16) {
            System.out.print("Key长度不是16位");
            return null;
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        keyGenerator.init(128, new SecureRandom(key.getBytes()));
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat , ALGORITHM);
        //"算法/模式/补码方式"
        Cipher cipher = Cipher.getInstance(PATTERN);
        cipher.init(Cipher.ENCRYPT_MODE, keySpec);
        byte[] encrypted = cipher.doFinal(content.getBytes(ENCODING));
        //使用BASE64做转码功能，能起到2次加密的作用。
        return new Base64().encodeToString(encrypted);
    }


    public static String Decrypt(String content, String key) throws Exception {
        try {
            // 判断Key是否为16位
            if (key.length() != 16) {
                System.out.print("Key长度不是16位");
                return null;
            }
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat , "AES");
            //"算法/模式/补码方式"
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, keySpec);
            //先base64解密
            byte[] encrypted1 = new Base64().decode(content);
            try {
                byte[] original = cipher.doFinal(encrypted1);
                String originalString = new String(original,"utf-8");
                return originalString;
            } catch (Exception e) {
                System.out.println(e.toString());
                return null;
            }
        } catch (Exception ex) {
            System.out.println(ex.toString());
            return null;
        }
    }
    
    public static void main(String[] args) throws Exception {
    	String json = "{\"appkey\":\"29722738\",\"secret\":\"KcWdOvmoCfOXUbZ2ab0u\",\"ip\":\"10.36.143.197\",\"port\":\"443\"}";
	    System.out.println(encrypt(json,"8749284927849201"));
	    System.out.println(Decrypt(encrypt(json,"8749284927849201"),"8749284927849201"));
    }
}
