package com.inzyme.spatiotemporal.common.properties;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

import com.inzy.common.constant.RegisterConstants;

//import io.netty.util.internal.ThreadLocalRandom;


/**   
 * @ClassName: ServiceDiscover    
 * @Description: 服务发现
 * @date 2023年9月14日 上午11:45:23    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
*/

@Component
public class ServiceDiscover {
	@Resource
	private RedisTemplate<String, Object> redisTemplate;
	
	/**
	 * 
	 * @Title: discover    
	 * @Description: 取得服务地址
	 * @param serviceName
	 * @return  
	 * String
	 */
	public String discover(String serviceName) {
		String url = null;
		String path = RegisterConstants.SERVICE_REGISTER_KEY + serviceName + ":";
//		Set<String> keys = redisTemplate.keys(path + "*");
		Set<String> keys = scan(path);
		if(null != keys && !keys.isEmpty()) {
			url = getRandomServiceUrl(keys).substring(path.length());
		}		
		return url;
	}
	
	
	/**
	 * 
	 * @Title: scan    
	 * @Description: scan
	 * @param matchKey
	 * @return  
	 * Set<String>
	 */
	private Set<String> scan(String matchKey) {
		Set<String> keys = (Set<String>) redisTemplate.execute((RedisCallback<Set<String>>) connection -> {
			Set<String> keysTmp = new HashSet<>();
			Cursor<byte[]> cursor = connection
					.scan(new ScanOptions.ScanOptionsBuilder().match(matchKey + "*").count(100).build());
			while (cursor.hasNext()) {
				keysTmp.add(new String(cursor.next()));
			}
			return keysTmp;
		});

		return keys;
	}
	
	/**
	 * 
	 * @Title: getRandomServiceUrl    
	 * @Description: 随机
	 * @param <E>
	 * @param set
	 * @return  
	 * E
	 */
	private static <E> E getRandomServiceUrl(Set<E> set) {
//	    return set.stream().skip(ThreadLocalRandom.current().nextInt(set.size())).findFirst().orElse(null);
	    return set.stream().skip(new Random().nextInt(set.size())).findFirst().orElse(null);
	}
}
