package com.inzyme.spatiotemporal.common.exception;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import com.inzyme.spatiotemporal.common.domain.enums.ResultEnum;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.handler.GlobalExceptionHandler;

/**
 * 添加注解异常捕捉
 * @author 86155
 *
 */
@Order(Integer.MIN_VALUE)
@RestControllerAdvice("com.inzyme.spatiotemporal.dianba.web")
public class GlobalsExceptionHandler extends GlobalExceptionHandler{

	/**
	 *获取参数注解异常
	 * @param e
	 * @return
	 */
	@ExceptionHandler(value = MethodArgumentNotValidException.class)
    public ReturnVO<Void> rbacExceptionHandler(MethodArgumentNotValidException e) {
    	// 获取异常信息
        BindingResult exceptions = e.getBindingResult();
    	if (exceptions.hasErrors()) {
    		List<ObjectError> allErrors = exceptions.getAllErrors();
            if (!allErrors.isEmpty()) {
                // 这里列出了全部错误参数，按正常逻辑，只需要第一条错误即可
                FieldError fieldError = (FieldError) allErrors.get(0);
                return new ReturnVO<>(ResultEnum.ERROR_POST_PARAM.getCode(), fieldError.getDefaultMessage());
            }
        }
    	return new ReturnVO<>(ReturnEnum.FAILED.getCode(), ReturnEnum.FAILED.getMessage());
    }
	
	/**
	 *获取参数注解异常
	 * @param e
	 * @return
	 */
	@ExceptionHandler(value = ApplicationException.class)
    public ReturnVO<Void> ApplicationExceptionHandler(ApplicationException e) {
    	String message = e.getMessage();
    	String code = e.getCode();
    	return new ReturnVO<>(code, message);
    }
}
