package com.inzyme.spatiotemporal.common.domain.vo;

import java.io.Serializable;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class UserVO implements Serializable{
	@ApiModelProperty(value = "用户ID")
	@JsonSerialize(using = ToStringSerializer.class)
	private long id ;
	
	private long userId;
	
	@ApiModelProperty(value = "用户名")
	private String username;
	@ApiModelProperty(value = "用户所属组织机构ID")
	private Long  orgId;
	@ApiModelProperty(value = "用户所属组织机构名称")
	private String orgName;
	@ApiModelProperty(value = "用户有效状态")
	private String enabled;
	
	@ApiModelProperty(value = "分页参数：当前页数")
	private long current;
	
	@ApiModelProperty(value = "分页参数：每页显示条数")
	private long size;
	
	@ApiModelProperty(value = "起始行")
	private long startrow;
	
	@ApiModelProperty(value = "用户角色(多个)")
	private String  roles;
	
}
