package com.inzyme.spatiotemporal.common.domain.vo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.inzyme.spatiotemporal.common.domain.entity.RoleMenu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description= "角色VO")
@Data
public class RoleVO implements java.io.Serializable {
	private static final long serialVersionUID = 8233123047520335500L;

	@ApiModelProperty(value = "角色ID")
	private Long roleId;
	
	@ApiModelProperty(value = "角色名")
	private String roleName;
	
	@ApiModelProperty(value = "分页参数：当前页数")
	private long current;
	
	@ApiModelProperty(value = "分页参数：每页显示条数")
	private long size;

	/**旧的接收集合留存，避免旧版本错误，不使用可以删除**/
	@ApiModelProperty(value = "所选角色权限ID")
	private Long [] menuIds;

	/** 树形控件打勾的 **/
	@ApiModelProperty(value = "打勾的角色权限")
	private List<RoleMenu> selectedMenuIds;
	/** 树形控件横杠的 **/
	@ApiModelProperty(value = "半选的角色权限")
	private List<RoleMenu> halfMenuIds;
	
	@ApiModelProperty(value = "查询条件")
	private Map<String, Object> condition = new HashMap<>();
}
