package com.inzyme.spatiotemporal.common.domain.vo;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.OperationLog;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 系统日志传参VO
 * @author wenxuan.hu
 * @date 2021-01-20
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class OperationLogVO implements Serializable {
	private static final long serialVersionUID = 6210242780344364981L;

	/** 查询条件 **/
	private String keyword;
	/** 开始时间 **/
//	注释因为查询报错，前端可能做过GMT+8的处理
//	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private Date beginTime;
	/** 截止时间 **/
//	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private Date endTime;
	
	@ApiModelProperty(value = "分页参数：当前页数")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long current;
	
	@ApiModelProperty(value = "分页参数：每页显示条数")
	private Long size;
}
