package com.inzyme.spatiotemporal.common.domain.enums;

import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * 枚举类
 * @author 86155
 *
 */
@Getter
@NoArgsConstructor
public enum ResultEnum {

    /**
           * 用于全局
     */
    ERROR_POST_PARAM("400", "访问参数异常"),
	/**
     * token-error
    */
	TOKEN_ERROR1("1001","获取token失败"),
	TOKEN_ERROR2("1002","获取username失败"),
	TOKEN_ERROR3("1003","获取userId失败"),    
	TOKEN_ERROR4("1004","token获取用户信息失败"),  


    ERROR_POST_METHOD("405", "访问方法异常"),
    FAILED("500", "访问异常,请稍后重试"),
    SUCCESS("200","success"),
    
    ENT_CODE_ISNULL("100001","社会信用代码为空"),
    ENT_INFO_ISNULL("100002","企业信息为空"),
    
    FILE_ISNULL("200001","文件为空"),
    FILE_NOT_EXCEL("200002","不是excel文件"),
    CONFIG_NOT_EXSITS("200003","下载模板未找到对应的配置"),
    GENERATEEXCE_ERROR("200003","生成excel模板异常"),
    ;
    private String code;

    private String message;

    ResultEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
