package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 用户信息
 * @author marquis
 *
 */
@TableName("admin_user_info")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class UserInfo extends CommonEntity implements Serializable {
	private static final long serialVersionUID = -1624401537616406448L;
	
	@JsonSerialize(using = ToStringSerializer.class)
	private Long userId;
	/** 用户姓名(中文) **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String fullname;
	/** 用户性别（m：男，  f：女） **/
	private String sex;
	/** 出生年月日 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String birth;
	/** 联系电话(手机) **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String phone;
	/** 邮箱地址 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String mailbox;
	/** 头像图片(地址) **/
	private String avatar;
	/** 自我介绍 **/
	private String introduction;

}
