package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.Treeable;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 组织机构
 * @author marquis
 *
 */
@TableName("admin_org")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class Org extends CommonEntity implements Treeable<Org>, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7340486792660683433L;

	@JsonSerialize(using = ToStringSerializer.class)
	private Long parentId;
	/** 组织机构编码(自动编码，用于递归查询下级组织) **/
	private String code;
	/**  组织机构名称**/
	private String name;
	/** 组织机构种类 **/
	private int orgType;
	/** 所属区域(采用6位的中国行政区域编码) **/
	private String areaCode;
	/** 显示排序 **/
	private int	orderNo;
	/** 描述 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String description;
	
	private transient List<Org> children;

}
