package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;
import java.util.List;

import org.springframework.security.core.GrantedAuthority;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.Treeable;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@TableName("admin_menu")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class Menu extends CommonEntity implements GrantedAuthority, Treeable<Menu>, Serializable {
	private static final long serialVersionUID = -3960466291350280123L;

	@JsonSerialize(using = ToStringSerializer.class)
	private Long parentId;
	/** 菜单映射路径 **/
	private String path;
	/** 菜单名称(权限编码) **/
	private String name;
	/** 菜单组件(vue页面) **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String component;
	/** 菜单传参(params) **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String params;
	/** 是否隐藏(0显示；1不显示) **/
	@TableField("is_hidden")
	private Integer hidden;
//	private Boolean hidden;
	/** 菜单跳转URL **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String redirect;
	/** 菜单显示名称 **/
	private String title;
	/** 菜单图标 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String icon;
	/** 是否检查token **/
	private Boolean requireAuth;
	/** 菜单种类（1：分类；2：页面；3：按钮） **/
	private Integer menuType;
	private transient String typeName;
	/** 是否外链(外链一般弹出新的标签页) **/
	@TableField("is_extra")
	private Boolean extra;
	/** 显示排序 **/
	private Integer orderNo;
	/** 描述 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String description;
	
	private transient List<Menu> children;
	
	@Override
	public String getAuthority() {
		return name;
	}

}
