package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 电子围栏表（线路和区域）
 * </p>
 *
 * @author yifan.wang
 * @since 2023-02-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据转换对象", description = "数据转换对象）")
public class GpsPoints implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "电子围栏几何形状经纬度 84坐标")
	// @TableField(typeHandler = GeometryTypeHandler.class)
	private String areaGeometry;

	@ApiModelProperty(value = "百度上图json 百度坐标")
	private String areaJson;

	@ApiModelProperty(value = "电子围栏几何形状经纬度String类型 84坐标")
	private String geoString;

}
