package com.inzyme.spatiotemporal.common.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 历史数据实体（SQLSERVER历史库）
 *
 * @author yifan.wang
 * @date 2023/02/6
 **/
@Data
@EqualsAndHashCode(callSuper = false)
public class GpsInfo {
    private static final long serialVersionUID = 1L;

    private long gpsId;

    /**
     * SIM卡号
     */
    private String simId;

    /**
     * 设备编号
     */
    private String plateNo;

    /**
     * 车辆id
     */
    private Integer vehicleId;

    /**
     * 定位时间
     */
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime SendTime;

    /**
     * 纬度
     */
    private String longitude;
    /**
     * 经度
     */
    private String latitude;

    /**
     * 速度
     */
    private Integer velocity;

    /**
     * 高度
     */
    private  Integer high;

    /**
     *锁状态
     */
    private String location;

    /**
     * 方向
     */
    private  Integer direction;

    /**
     * 里程
     */
    private  Integer mileage;

    /**
     * 电压
     */
    private  Integer voltage;



}
