package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.Treeable;
import com.inzyme.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 数据字典
 * @author marquis
 *
 */
@TableName("admin_dict")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class Dict extends CommonEntity implements Treeable<Dict>, Serializable {
	private static final long serialVersionUID = -2981820442285311390L;

	@JsonSerialize(using = ToStringSerializer.class)
	private Long parentId;
	/** 数据字典分类code **/
	private String dictType;
	/** 标签(显示值) **/
	private String label;
	/** 值 **/
	private String value;
	/** 状态，1：隐藏   0：显示 **/
	@TableField("is_hidden")
	private Boolean hidden;
	/** 显示排序 **/
	private Integer orderNo;
	/** 描述 **/
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String description;
	
	private transient List<Dict> children;
}
