package com.inzyme.spatiotemporal.common.domain.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.inzyme.spatiotemporal.web.core.domain.Treeable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 区域管理实体
 * @author wenxuan.hu
 * @date 2020-12-07
 */
@TableName("admin_area")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class Area implements Treeable<Area>, Serializable {
	private static final long serialVersionUID = -2537930565289902129L;

	/** 自增主键 **/
	@TableId(value = "area_id", type = IdType.AUTO)
	@JsonSerialize(using = ToStringSerializer.class)
	private Long areaId;
	/** 行政区划代码 **/
	private String areaCode;
	/** 上级行政区划代码 **/
	private String parentCode;
	/** 地区名称 **/
	private String name;
	/** 层级 1:省级,2:地市,3:区县 **/
	private Integer layer;
	/** 排序号 **/
	private Integer orderNum;
	/** 显示,1:显示,0:隐藏 **/
	private Integer status;
	/** 备注 **/
	private String remark;
	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private Date gmtCreate;
	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private Date gmtModified;
	
	private transient String parentName;
	private transient List<Area> children;
	@Override
	public Serializable getId() {
		return areaCode;
	}
	@Override
	public Serializable getParentId() {
		return parentCode;
	}

}
