package com.inzyme.spatiotemporal.common.domain.dto;

import java.io.Serializable;

import lombok.Data;
import lombok.ToString;

/**
 * @ClassName: Point
 * @Description: 坐标点
 * @date 2023年3月8日 上午10:22:33
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
@Data
@ToString
public class Point implements Serializable {
	/**   
	 * @Fields serialVersionUID : TODO(用一句话描述这个变量表示什么)   
	 */ 
	private static final long serialVersionUID = 4134571493063671472L;

	/**
	 * 经度（-180~180，东经正数，西经负数）
	 */
	private double lng;
	
	/**
	 * 维度（-90~90，北纬正数，南纬负数）
	 */
	private double lat;

	/**
	 * 
	 * Creates a new instance of Point.
	 *
	 * @param lng
	 * @param lat
	 */
	public Point(double lng, double lat) {
		this.lng = lng;
		this.lat = lat;
	}
}