package com.inzyme.spatiotemporal.common.dao.web.system;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.inzyme.spatiotemporal.common.domain.vo.CasUserBean;
import com.inzyme.spatiotemporal.common.domain.vo.UserVO;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;

@Mapper
public interface UserDao extends BaseMapper<User> {
	
	public List<UserVO> selectUserList(UserVO userVO);
	
	public Long selectUserCount(UserVO userVO);
	
	public Integer  insertUser(User user);
	
	public User selectUserByUserName(String username);
	
	public User selectUserByAccountAndPwd(@Param("username") String username,
										@Param("password") String password);
	
	
	public List<CasUserBean> selectAllUserInfo();
	
}
