package com.inzyme.spatiotemporal.common.dao.web.system;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.inzyme.spatiotemporal.common.domain.entity.Menu;

@Mapper
public interface MenuDao extends BaseMapper<Menu> {

	/**
	 * 查询指定复数个角色的菜单列表
	 * @param roleIds
	 * @return
	 */
	public List<Menu> selectRoleMenus(List<Long> roleIds);

	/**
	 * 查询子菜单下是否有重复项
	 * @param menu
	 * @return
	 */
    public List<Menu> queryRepetitionZi(Menu menu);
    /**
     * 查询父菜单下是否有重复项
     * @param menu
     * @return
     */
    public List<Menu> queryRepetitionFu(Menu menu);
}
