package com.inzyme.spatiotemporal.common.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;


/**
 * 
 * @ClassName: UserTypeConverter    
 * @Description: 用户类型转换器
 * @date 2023年7月3日 下午1:50:54    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */
public class UserTypeConverter implements Converter<Integer> {
    @Override
    public Class<?> supportJavaTypeKey() {
        //对象属性类型
        return Integer.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        //CellData属性类型
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Integer convertToJavaData(ReadConverterContext<?> context) throws Exception {
        //CellData转对象属性
        String cellStr = context.getReadCellData().getStringValue();
        if (StrUtil.isEmpty(cellStr)) return null;
        if ("部门".equals(cellStr)) {
            return 1;
        } else if ("运输公司".equals(cellStr)) {
            return 2;
        } else if ("司机".equals(cellStr)) {
            return 3;
        }else {
            return null;
        }
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Integer> context) throws Exception {
        //对象属性转CellData
        Integer cellValue = context.getValue();
        if (cellValue == null) {
            return new WriteCellData<>("");
        }
        if (cellValue == 1) {
            return new WriteCellData<>("部门");
        } else if (cellValue == 2) {
            return new WriteCellData<>("运输公司");
        } else if (cellValue == 3) {
            return new WriteCellData<>("司机");
        }else {
            return new WriteCellData<>("");
        }
    }
}