/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import org.locationtech.jts.geom.Envelope;

public class PackedRTree {
    private static int NODE_ITEM_LEN = 40;

    public static long calcSize(int numItems, int nodeSize) {
        int n;
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        int nodeSizeMin = Math.min(Math.max(nodeSize, 2), 65535);
        if (numItems > 0x1000000) {
            throw new IndexOutOfBoundsException("Number of items must be less than 2^56");
        }
        int numNodes = n = numItems;
        do {
            n = (n + nodeSizeMin - 1) / nodeSizeMin;
            numNodes += n;
        } while (n != 1);
        return numNodes * NODE_ITEM_LEN;
    }

    static ArrayList<Integer> generateLevelEnds(int numItems, int nodeSize) {
        int n;
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        int numNodes = n = numItems;
        ArrayList<Integer> levelNumNodes = new ArrayList<Integer>();
        levelNumNodes.add(n);
        do {
            n = (n + nodeSize - 1) / nodeSize;
            numNodes += n;
            levelNumNodes.add(n);
        } while (n != 1);
        ArrayList<Integer> levelOffsets = new ArrayList<Integer>();
        n = numNodes;
        Iterator iterator = levelNumNodes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            levelOffsets.add(n - size);
            n -= size;
        }
        Collections.reverse(levelOffsets);
        Collections.reverse(levelNumNodes);
        ArrayList<Integer> levelEnds = new ArrayList<Integer>();
        for (int i = 0; i < levelNumNodes.size(); ++i) {
            levelEnds.add((Integer)levelOffsets.get(i) + (Integer)levelNumNodes.get(i));
        }
        Collections.reverse(levelEnds);
        return levelEnds;
    }

    public static ArrayList<SearchHit> search(ByteBuffer bb, int start, int numItems, int nodeSize, Envelope rect) {
        ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
        double minX = rect.getMinX();
        double minY = rect.getMinY();
        double maxX = rect.getMaxX();
        double maxY = rect.getMaxY();
        ArrayList<Integer> levelEnds = PackedRTree.generateLevelEnds(numItems, nodeSize);
        int numNodes = levelEnds.get(0);
        Stack<StackItem> stack = new Stack<StackItem>();
        stack.add(new StackItem(0L, levelEnds.size() - 1));
        while (stack.size() != 0) {
            StackItem stackItem = (StackItem)stack.pop();
            int nodeIndex = (int)stackItem.nodeIndex;
            int level = stackItem.level;
            boolean isLeafNode = nodeIndex >= numNodes - numItems;
            int levelEnd = levelEnds.get(level);
            int end = Math.min(nodeIndex + nodeSize, levelEnd);
            int nodeStart = start + nodeIndex * NODE_ITEM_LEN;
            for (int pos = nodeIndex; pos < end; ++pos) {
                int offset = nodeStart + (pos - nodeIndex) * NODE_ITEM_LEN;
                double nodeMinX = bb.getDouble(offset + 0);
                double nodeMinY = bb.getDouble(offset + 8);
                double nodeMaxX = bb.getDouble(offset + 16);
                double nodeMaxY = bb.getDouble(offset + 24);
                if (maxX < nodeMinX || maxY < nodeMinY || minX > nodeMaxX || minY > nodeMaxY) continue;
                long indexOffset = bb.getLong(offset + 32);
                if (isLeafNode) {
                    searchHits.add(new SearchHit(indexOffset, pos - 1));
                    continue;
                }
                stack.add(new StackItem(indexOffset, level - 1));
            }
        }
        return searchHits;
    }

    public static SearchResult search(InputStream stream, int start, int numItems, int nodeSize, Envelope rect) throws IOException {
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        int dataPos = 0;
        SearchResult searchResult = new SearchResult();
        double minX = rect.getMinX();
        double minY = rect.getMinY();
        double maxX = rect.getMaxX();
        double maxY = rect.getMaxY();
        ArrayList<Integer> levelEnds = PackedRTree.generateLevelEnds(numItems, nodeSize);
        int numNodes = levelEnds.get(0);
        Stack<StackItem> stack = new Stack<StackItem>();
        stack.add(new StackItem(0L, levelEnds.size() - 1));
        while (stack.size() != 0) {
            StackItem stackItem = (StackItem)stack.pop();
            int nodeIndex = (int)stackItem.nodeIndex;
            int level = stackItem.level;
            boolean isLeafNode = nodeIndex >= numNodes - numItems;
            int levelBound = levelEnds.get(level);
            int end = Math.min(nodeIndex + nodeSize, levelBound);
            int nodeStart = nodeIndex * NODE_ITEM_LEN;
            int skip = nodeStart - dataPos;
            if (skip > 0) {
                PackedRTree.skipNBytes((InputStream)data, skip);
                dataPos += skip;
            }
            for (int pos = nodeIndex; pos < end; ++pos) {
                int offset = nodeStart + (pos - nodeIndex) * NODE_ITEM_LEN;
                skip = offset - dataPos;
                if (skip > 0) {
                    PackedRTree.skipNBytes((InputStream)data, skip);
                    dataPos += skip;
                }
                double nodeMinX = data.readDouble();
                dataPos += 8;
                if (maxX < nodeMinX) continue;
                double nodeMinY = data.readDouble();
                dataPos += 8;
                if (maxY < nodeMinY) continue;
                double nodeMaxX = data.readDouble();
                dataPos += 8;
                if (minX > nodeMaxX) continue;
                double nodeMaxY = data.readDouble();
                dataPos += 8;
                if (minY > nodeMaxY) continue;
                long indexOffset = data.readLong();
                dataPos += 8;
                if (isLeafNode) {
                    searchResult.hits.add(new SearchHit(indexOffset, pos - 1));
                    continue;
                }
                stack.add(new StackItem(indexOffset, level - 1));
            }
            stack.sort((a, b) -> (int)(b.nodeIndex - a.nodeIndex));
        }
        searchResult.pos = dataPos;
        return searchResult;
    }

    static void skipNBytes(InputStream stream, long skip) throws IOException {
        long actual = 0L;
        for (long remaining = skip; actual < remaining; remaining -= stream.skip(remaining)) {
        }
    }

    public static class SearchResult {
        public ArrayList<SearchHit> hits = new ArrayList();
        public int pos;
    }

    public static class SearchHit {
        public long offset;
        public long index;

        public SearchHit(long offset, long index) {
            this.offset = offset;
            this.index = index;
        }
    }

    private static class StackItem {
        long nodeIndex;
        int level;

        public StackItem(long nodeIndex, int level) {
            this.nodeIndex = nodeIndex;
            this.level = level;
        }
    }
}

