/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.wololo.flatgeobuf.GeometryOffsets;
import org.wololo.flatgeobuf.generated.Geometry;

public class GeometryConversions {
    public static GeometryOffsets serializePart(FlatBufferBuilder builder, org.locationtech.jts.geom.Geometry geometry, int geometryType) throws IOException {
        GeometryOffsets go = new GeometryOffsets();
        if (geometry == null) {
            return go;
        }
        if (geometryType == 5) {
            int end = 0;
            MultiLineString mls = (MultiLineString)geometry;
            if (mls.getNumGeometries() > 1) {
                go.ends = new int[mls.getNumGeometries()];
                for (int i = 0; i < mls.getNumGeometries(); ++i) {
                    go.ends[i] = end += mls.getGeometryN(i).getNumPoints();
                }
            }
        } else if (geometryType == 3) {
            int end;
            Polygon p = (Polygon)geometry;
            go.ends = new int[p.getNumInteriorRing() + 1];
            go.ends[0] = end = p.getExteriorRing().getNumPoints();
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                go.ends[i + 1] = end += p.getInteriorRingN(i).getNumPoints();
            }
        } else if (geometryType == 6) {
            MultiPolygon mp = (MultiPolygon)geometry;
            int numGeometries = mp.getNumGeometries();
            GeometryOffsets[] gos = new GeometryOffsets[numGeometries];
            for (int i = 0; i < numGeometries; ++i) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                gos[i] = GeometryConversions.serializePart(builder, (org.locationtech.jts.geom.Geometry)p, 3);
            }
            go.gos = gos;
            return go;
        }
        int numPoints = geometry.getNumPoints();
        Geometry.startXyVector(builder, 2 * numPoints);
        GeometryConversions.applyInReverseOrder(geometry, new ReverseXYCoordinateSequenceFilter(builder));
        go.coordsOffset = builder.endVector();
        if (go.ends != null) {
            go.endsOffset = Geometry.createEndsVector(builder, go.ends);
        }
        go.type = geometryType;
        return go;
    }

    public static int serialize(FlatBufferBuilder builder, org.locationtech.jts.geom.Geometry geometry, byte geometryType) throws IOException {
        int geometryOffset;
        byte knownGeometryType = geometryType;
        if (geometryType == 0) {
            knownGeometryType = GeometryConversions.toGeometryType(geometry.getClass());
        }
        GeometryOffsets go = GeometryConversions.serializePart(builder, geometry, knownGeometryType);
        if (go.gos != null && go.gos.length > 0) {
            int[] partOffsets = new int[go.gos.length];
            for (int i = 0; i < go.gos.length; ++i) {
                int partOffset;
                GeometryOffsets goPart = go.gos[i];
                partOffsets[i] = partOffset = Geometry.createGeometry(builder, goPart.endsOffset, goPart.coordsOffset, 0, 0, 0, 0, goPart.type, 0);
            }
            int partsOffset = Geometry.createPartsVector(builder, partOffsets);
            geometryOffset = Geometry.createGeometry(builder, 0, 0, 0, 0, 0, 0, geometryType == 0 ? knownGeometryType : (byte)0, partsOffset);
        } else {
            geometryOffset = Geometry.createGeometry(builder, go.endsOffset, go.coordsOffset, 0, 0, 0, 0, geometryType == 0 ? knownGeometryType : (byte)0, 0);
        }
        return geometryOffset;
    }

    private static void applyInReverseOrder(org.locationtech.jts.geom.Geometry geometry, CoordinateSequenceFilter filter) {
        int numGeometries = geometry.getNumGeometries();
        if (numGeometries > 1) {
            for (int i = numGeometries - 1; i >= 0; --i) {
                org.locationtech.jts.geom.Geometry sub = geometry.getGeometryN(i);
                GeometryConversions.applyInReverseOrder(sub, filter);
            }
        } else if (geometry instanceof Polygon) {
            Polygon p = (Polygon)geometry;
            for (int i = p.getNumInteriorRing() - 1; i >= 0; --i) {
                LinearRing hole = p.getInteriorRingN(i);
                GeometryConversions.applyInReverseOrder((org.locationtech.jts.geom.Geometry)hole, filter);
            }
            GeometryConversions.applyInReverseOrder((org.locationtech.jts.geom.Geometry)p.getExteriorRing(), filter);
        } else {
            geometry.apply(filter);
        }
    }

    public static org.locationtech.jts.geom.Geometry deserialize(Geometry geometry, int geometryType) {
        GeometryFactory factory = new GeometryFactory();
        switch (geometryType) {
            case 6: {
                int partsLength = geometry.partsLength();
                Polygon[] polygons = new Polygon[partsLength];
                for (int i = 0; i < geometry.partsLength(); ++i) {
                    polygons[i] = (Polygon)GeometryConversions.deserialize(geometry.parts(i), 3);
                }
                return factory.createMultiPolygon(polygons);
            }
        }
        int xyLength = geometry.xyLength();
        Coordinate[] coordinates = new Coordinate[xyLength >> 1];
        int c = 0;
        for (int i = 0; i < xyLength; i += 2) {
            coordinates[c++] = new Coordinate(geometry.xy(i), geometry.xy(i + 1));
        }
        IntFunction<Polygon> makePolygonWithRings = endsLength -> {
            LinearRing[] lrs = new LinearRing[endsLength];
            int s = 0;
            for (int i = 0; i < endsLength; ++i) {
                int e = (int)geometry.ends(i);
                Coordinate[] cs = Arrays.copyOfRange(coordinates, s, e);
                lrs[i] = factory.createLinearRing(cs);
                s = e;
            }
            LinearRing shell = lrs[0];
            LinearRing[] holes = Arrays.copyOfRange(lrs, 1, endsLength);
            return factory.createPolygon(shell, holes);
        };
        Supplier<Polygon> makePolygon = () -> {
            int endsLength = geometry.endsLength();
            if (endsLength > 1) {
                return (Polygon)makePolygonWithRings.apply(endsLength);
            }
            return factory.createPolygon(coordinates);
        };
        switch (geometryType) {
            case 0: {
                return null;
            }
            case 1: {
                if (coordinates.length > 0) {
                    return factory.createPoint(coordinates[0]);
                }
                return factory.createPoint();
            }
            case 4: {
                return factory.createMultiPointFromCoords(coordinates);
            }
            case 2: {
                return factory.createLineString(coordinates);
            }
            case 5: {
                int lengthLengths = geometry.endsLength();
                if (lengthLengths < 2) {
                    return factory.createMultiLineString(new LineString[]{factory.createLineString(coordinates)});
                }
                LineString[] lss = new LineString[lengthLengths];
                int s = 0;
                for (int i = 0; i < lengthLengths; ++i) {
                    int e = (int)geometry.ends(i);
                    Coordinate[] cs = Arrays.copyOfRange(coordinates, s, e);
                    lss[i] = factory.createLineString(cs);
                    s = e;
                }
                return factory.createMultiLineString(lss);
            }
            case 3: {
                return (org.locationtech.jts.geom.Geometry)makePolygon.get();
            }
        }
        throw new RuntimeException("Unknown geometry type");
    }

    public static Class<?> getGeometryClass(int geometryType) {
        switch (geometryType) {
            case 0: {
                return Geometry.class;
            }
            case 1: {
                return Point.class;
            }
            case 4: {
                return MultiPoint.class;
            }
            case 2: {
                return LineString.class;
            }
            case 5: {
                return MultiLineString.class;
            }
            case 3: {
                return Polygon.class;
            }
            case 6: {
                return MultiPolygon.class;
            }
        }
        throw new RuntimeException("Unknown geometry type");
    }

    public static byte toGeometryType(Class<?> geometryClass) {
        if (geometryClass == org.locationtech.jts.geom.Geometry.class) {
            return 0;
        }
        if (MultiPoint.class.isAssignableFrom(geometryClass)) {
            return 4;
        }
        if (Point.class.isAssignableFrom(geometryClass)) {
            return 1;
        }
        if (MultiLineString.class.isAssignableFrom(geometryClass)) {
            return 5;
        }
        if (LineString.class.isAssignableFrom(geometryClass)) {
            return 2;
        }
        if (MultiPolygon.class.isAssignableFrom(geometryClass)) {
            return 6;
        }
        if (Polygon.class.isAssignableFrom(geometryClass)) {
            return 3;
        }
        throw new RuntimeException("Unknown geometry type");
    }

    private static class ReverseXYCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private FlatBufferBuilder builder;

        ReverseXYCoordinateSequenceFilter(FlatBufferBuilder builder) {
            this.builder = builder;
        }

        public void filter(CoordinateSequence seq, int coordIndex) {
            int reverseSeqIndex = seq.size() - coordIndex - 1;
            double y = seq.getOrdinate(reverseSeqIndex, 1);
            double x = seq.getOrdinate(reverseSeqIndex, 0);
            this.builder.addDouble(y);
            this.builder.addDouble(x);
        }

        public boolean isGeometryChanged() {
            return false;
        }

        public boolean isDone() {
            return false;
        }
    }
}

