/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;

public abstract class Logger
extends AbstractImmutableNativeReference {
    final long nativeHandle_;

    public Logger(Options options) {
        super(true);
        this.nativeHandle_ = this.createNewLoggerOptions(options.nativeHandle_);
    }

    public Logger(DBOptions dBOptions) {
        super(true);
        this.nativeHandle_ = this.createNewLoggerDbOptions(dBOptions.nativeHandle_);
    }

    public void setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
    }

    public InfoLogLevel infoLogLevel() {
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    protected abstract void log(InfoLogLevel var1, String var2);

    @Override
    protected void disposeInternal() {
        this.disposeInternal(this.nativeHandle_);
    }

    protected native long createNewLoggerOptions(long var1);

    protected native long createNewLoggerDbOptions(long var1);

    protected native void setInfoLogLevel(long var1, byte var3);

    protected native byte infoLogLevel(long var1);

    private native void disposeInternal(long var1);
}

