/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Covers
extends DeterministicScalarFunction {
    public ST_Covers() {
        this.addProperty("remarks", "Returns true if no point in geometry B is outside geometry A.");
    }

    public String getJavaStaticMethod() {
        return "covers";
    }

    public static Boolean covers(Geometry geomA, Geometry geomB) throws SQLException {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.getSRID() != geomB.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return geomA.covers(geomB);
    }
}

