/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.linear_referencing;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.linearref.LengthIndexedLine;

public class ST_LineSubstring
extends DeterministicScalarFunction {
    public ST_LineSubstring() {
        this.addProperty("remarks", "Extract a section of the input LineString or MultiLineString starting and ending at the given fractions.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry, double start, double end) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (start < 0.0 || start > 1.0) {
            throw new SQLException("Allowed between 0 and  1");
        }
        if (end < 0.0 || end > 1.0) {
            throw new SQLException("Allowed between 0 and  1");
        }
        if (start > end) {
            throw new SQLException("Start fraction must be smaller than end fraction");
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        if (geometry instanceof LineString) {
            double length = geometry.getLength();
            LengthIndexedLine ll = new LengthIndexedLine(geometry);
            return ll.extractLine(start * length, end * length);
        }
        if (geometry instanceof MultiLineString) {
            int nb = geometry.getNumGeometries();
            ArrayList<LineString> lines = new ArrayList<LineString>();
            for (int i = 0; i < nb; ++i) {
                Geometry line = geometry.getGeometryN(i);
                double length = line.getLength();
                LengthIndexedLine ll = new LengthIndexedLine(geometry.getGeometryN(i));
                lines.add((LineString)ll.extractLine(start * length, end * length));
            }
            return geometry.getFactory().createMultiLineString(lines.toArray(new LineString[0]));
        }
        throw new SQLException("Only LineString or MultiLineString are supported");
    }
}

