/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.linear_referencing;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.linearref.LengthIndexedLine;

public class ST_LineInterpolatePoint
extends DeterministicScalarFunction {
    public ST_LineInterpolatePoint() {
        this.addProperty("remarks", "Returns a point interpolate along the input LineString or MultiLineString starting at the given fraction.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry, double start) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (start < 0.0 || start > 1.0) {
            throw new SQLException("Allowed between 0 and  1");
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        if (geometry instanceof LineString) {
            double length = geometry.getLength();
            LengthIndexedLine ll = new LengthIndexedLine(geometry);
            return geometry.getFactory().createPoint(ll.extractPoint(start * length));
        }
        if (geometry instanceof MultiLineString) {
            int nb = geometry.getNumGeometries();
            ArrayList<Coordinate> points = new ArrayList<Coordinate>();
            for (int i = 0; i < nb; ++i) {
                Geometry line = geometry.getGeometryN(i);
                double length = line.getLength();
                LengthIndexedLine ll = new LengthIndexedLine(geometry.getGeometryN(i));
                points.add(ll.extractPoint(start * length));
            }
            return geometry.getFactory().createMultiPointFromCoords(points.toArray(new Coordinate[0]));
        }
        throw new SQLException("Only LineString or MultiLineString are supported");
    }
}

