/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_GeneratePointsInGrid
extends DeterministicScalarFunction {
    static PointOnGeometryLocator extentLocator;

    public ST_GeneratePointsInGrid() {
        this.addProperty("remarks", "ST_GeneratePointsInGrid(Geometry geom, int cellSizeX, int cellSizeY, boolean useMask)\n generates a regular set of points according a x and y cell sizes. \nThe usemask argument is used to keep the points located inside the input geometry. \n");
    }

    public String getJavaStaticMethod() {
        return "generatePointsInGrid";
    }

    public static Geometry generatePointsInGrid(Geometry geom, int cellSizeX, int cellSizeY) throws SQLException {
        return ST_GeneratePointsInGrid.generatePointsInGrid(geom, cellSizeX, cellSizeY, false);
    }

    public static Geometry generatePointsInGrid(Geometry geom, int cellSizeX, int cellSizeY, boolean useMask) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (geom.isEmpty()) {
            return null;
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            GeometryFactory geomFact = geom.getFactory();
            List<Coordinate> geoms = ST_GeneratePointsInGrid.createGridPoints(geom, cellSizeX, cellSizeY, useMask);
            return geomFact.createMultiPointFromCoords(geoms.toArray(new Coordinate[0]));
        }
        throw new SQLException("Only polygon or multipolygon is supported");
    }

    static List<Coordinate> createGridPoints(Geometry geom, int cellSizeX, int cellSizeY, boolean useMask) {
        Envelope env = geom.getEnvelopeInternal();
        int nCellsOnSideX = (int)(env.getWidth() / (double)cellSizeX) + 1;
        int nCellsOnSideY = (int)(env.getHeight() / (double)cellSizeY) + 1;
        ArrayList<Coordinate> geoms = new ArrayList<Coordinate>();
        double envMinX = env.getMinX() + env.getWidth() % (double)cellSizeX / 2.0;
        double envMinY = env.getMinY() + env.getHeight() % (double)cellSizeY / 2.0;
        if (useMask) {
            extentLocator = new IndexedPointInAreaLocator(geom);
            for (int i = 0; i < nCellsOnSideX; ++i) {
                for (int j = 0; j < nCellsOnSideY; ++j) {
                    Coordinate c = new Coordinate(envMinX + (double)(i * cellSizeX), envMinY + (double)(j * cellSizeY));
                    if (extentLocator.locate(c) == 2) continue;
                    geoms.add(c);
                }
            }
        } else {
            for (int i = 0; i < nCellsOnSideX; ++i) {
                for (int j = 0; j < nCellsOnSideY; ++j) {
                    geoms.add(new Coordinate(envMinX + (double)(i * cellSizeX), envMinY + (double)(j * cellSizeY)));
                }
            }
        }
        return geoms;
    }
}

