/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class MinimumBoundingRadiusRowSet
implements SimpleRowSource {
    private final Connection connection;
    private String tableName;
    private boolean firstRow = true;
    public ResultSet tableQuery;
    public int spatialFieldIndex;
    public int explodeId = 1;
    private int columnCount;

    public MinimumBoundingRadiusRowSet(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    public Object[] readRow() throws SQLException {
        if (this.firstRow) {
            this.reset();
        }
        if (this.tableQuery.next()) {
            Object[] objects = new Object[this.columnCount + 3];
            Point centerGeom = null;
            Double radiusGeom = null;
            for (int i = 1; i <= this.columnCount; ++i) {
                if (i == this.spatialFieldIndex) {
                    Geometry geomTable = (Geometry)this.tableQuery.getObject(this.spatialFieldIndex);
                    if (geomTable != null) {
                        MinimumBoundingCircle mbc = new MinimumBoundingCircle(geomTable);
                        centerGeom = geomTable.getFactory().createPoint(mbc.getCentre());
                        centerGeom.setSRID(geomTable.getSRID());
                        radiusGeom = mbc.getRadius();
                    }
                    objects[i - 1] = geomTable;
                    continue;
                }
                objects[i - 1] = this.tableQuery.getObject(i);
            }
            objects[this.columnCount] = this.explodeId++;
            objects[this.columnCount + 1] = centerGeom;
            objects[this.columnCount + 2] = radiusGeom;
            return objects;
        }
        return null;
    }

    public void close() {
        if (this.tableQuery != null) {
            try {
                this.tableQuery.close();
                this.tableQuery = null;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset() throws SQLException {
        String regex;
        Pattern pattern;
        Matcher matcher;
        if (this.tableQuery != null && !this.tableQuery.isClosed()) {
            this.close();
        }
        if ((matcher = (pattern = Pattern.compile(regex = ".*(?i)\\b(select|from)\\b.*")).matcher(this.tableName)).find()) {
            if (!this.tableName.startsWith("(") || !this.tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery(this.tableName);
            this.spatialFieldIndex = (Integer)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSetMetaData)this.tableQuery.getMetaData()).second();
        } else {
            TableLocation tableLocation = TableLocation.parse((String)this.tableName, (DBTypes)DBUtils.getDBType((Connection)this.connection));
            this.spatialFieldIndex = (Integer)GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.connection, (TableLocation)tableLocation).second();
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery("select * from " + this.tableName);
        }
        this.firstRow = false;
        ResultSetMetaData meta = this.tableQuery.getMetaData();
        this.columnCount = meta.getColumnCount();
    }

    public ResultSet getResultSet() throws SQLException {
        SimpleResultSet srs = new SimpleResultSet((SimpleRowSource)this);
        this.copyFields(srs);
        srs.addColumn("ID", 4, 10, 0);
        srs.addColumn("CENTER", 1111, "GEOMETRY", 0, 0);
        srs.addColumn("RADIUS", 8, 10, 0);
        return srs;
    }

    private void copyFields(SimpleResultSet srs) throws SQLException {
        block18: {
            String regex = ".*(?i)\\b(select|from)\\b.*";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(this.tableName);
            if (matcher.find()) {
                if (this.tableName.startsWith("(") && this.tableName.endsWith(")")) {
                    try (ResultSet rs = this.connection.createStatement().executeQuery(this.tableName);){
                        TableUtilities.copyFields((SimpleResultSet)srs, (ResultSetMetaData)rs.getMetaData());
                        break block18;
                    }
                    catch (SQLException e) {
                        throw new SQLException(e);
                    }
                }
                throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            }
            try (ResultSet rs = this.connection.createStatement().executeQuery("select * from " + this.tableName);){
                TableUtilities.copyFields((SimpleResultSet)srs, (ResultSetMetaData)rs.getMetaData());
            }
            catch (SQLException e) {
                throw new SQLException(e);
            }
        }
    }
}

