/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ST_OSMMapLink
extends DeterministicScalarFunction {
    public ST_OSMMapLink() {
        this.addProperty("remarks", "Generate an OSM map link URL based on the bounding box of the input geometry.\nAn optional argument could be used to place a marker on the center of the bounding box.");
    }

    public String getJavaStaticMethod() {
        return "generateLink";
    }

    public static String generateLink(Geometry geom) {
        return ST_OSMMapLink.generateLink(geom, false);
    }

    public static String generateLink(Geometry geom, boolean withMarker) {
        if (geom == null) {
            return null;
        }
        Envelope env = geom.getEnvelopeInternal();
        StringBuilder sb = new StringBuilder("http://www.openstreetmap.org/?");
        sb.append("minlon=").append(env.getMinX());
        sb.append("&minlat=").append(env.getMinY());
        sb.append("&maxlon=").append(env.getMaxX());
        sb.append("&maxlat=").append(env.getMaxY());
        if (withMarker) {
            Coordinate centre = env.centre();
            sb.append("&mlat=").append(centre.y);
            sb.append("&mlon=").append(centre.x);
        }
        return sb.toString();
    }
}

