/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ST_Force3D
extends DeterministicScalarFunction {
    static final GeometryFactory gf = new GeometryFactory();

    public ST_Force3D() {
        this.addProperty("remarks", "Forces the geometries into XYZ mode.\n If a geometry has no Z component, then a Z value is tacked on. \nDefault z value is set to zero");
    }

    public String getJavaStaticMethod() {
        return "force3D";
    }

    public static Geometry force3D(Geometry geom) {
        if (geom == null) {
            return null;
        }
        return ST_Force3D.force(geom, 0.0);
    }

    public static Geometry force3D(Geometry geom, double zValue) {
        if (geom == null) {
            return null;
        }
        return ST_Force3D.force(geom, zValue);
    }

    public static Geometry force(Geometry geom, double zValue) {
        Geometry g = geom;
        if (geom instanceof Point) {
            g = gf.createPoint((CoordinateSequence)ST_Force3D.convertSequence(((Point)geom).getCoordinateSequence(), zValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof LineString) {
            g = gf.createLineString((CoordinateSequence)ST_Force3D.convertSequence(((LineString)geom).getCoordinateSequence(), zValue));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof Polygon) {
            g = ST_Force3D.convert((Polygon)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = ST_Force3D.convert((MultiPoint)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = ST_Force3D.convert((MultiLineString)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = ST_Force3D.convert((MultiPolygon)geom, zValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = ST_Force3D.convert((GeometryCollection)geom, zValue);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static MultiPoint convert(MultiPoint mp, double zValue) {
        int nb = mp.getNumGeometries();
        Point[] geometries = new Point[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = (Point)ST_Force3D.force(mp.getGeometryN(i), zValue);
        }
        return gf.createMultiPoint(geometries);
    }

    public static GeometryCollection convert(GeometryCollection gc, double zValue) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_Force3D.force(gc.getGeometryN(i), zValue);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, double zValue) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = ST_Force3D.convert((Polygon)multiPolygon.getGeometryN(i), zValue);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, double zValue) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = ST_Force3D.convert((LineString)multiLineString.getGeometryN(i), zValue);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, double zValue) {
        LinearRing shell = gf.createLinearRing((CoordinateSequence)ST_Force3D.convertSequence(polygon.getExteriorRing().getCoordinateSequence(), zValue));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)ST_Force3D.convertSequence(polygon.getInteriorRingN(i).getCoordinateSequence(), zValue));
        }
        return gf.createPolygon(shell, holes);
    }

    public static LineString convert(LineString lineString, double zValue) {
        return gf.createLineString((CoordinateSequence)ST_Force3D.convertSequence(lineString.getCoordinateSequence(), zValue));
    }

    public static LinearRing convert(LinearRing linearRing, double zValue) {
        return gf.createLinearRing((CoordinateSequence)ST_Force3D.convertSequence(linearRing.getCoordinateSequence(), zValue));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs, double zValue) {
        Coordinate[] coords = new Coordinate[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coord = cs.getCoordinate(i);
            coord = new Coordinate(coord);
            double z = coord.z;
            if (Double.isNaN(z)) {
                coord.setZ(zValue);
            }
            coords[i] = coord;
        }
        return new CoordinateArraySequence(coords, 3);
    }
}

