/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileException;
import org.h2gis.functions.io.utility.CoordinatesUtils;
import org.h2gis.functions.io.utility.ReadBufferManager;
import org.h2gis.functions.io.utility.WriteBufferManager;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.algorithm.RobustDeterminant;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory = new GeometryFactory();
    final ShapeType shapeType;

    public PolygonHandler() {
        this.shapeType = ShapeType.POLYGON;
    }

    public PolygonHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Geometry geometry) {
        int length;
        if (geometry.isEmpty()) {
            return 2;
        }
        int nrings = 0;
        int size = geometry.getNumGeometries();
        for (int t = 0; t < size; ++t) {
            Polygon p = (Polygon)geometry.getGeometryN(t);
            nrings += nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = geometry.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return length;
    }

    @Override
    public Geometry read(ReadBufferManager buffer, ShapeType type) throws IOException {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.skip(32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.POLYGONZ ? 3 : 2;
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>(numParts);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(numParts);
        CoordinateSequence coords = this.readCoordinates(buffer, numPoints, dimensions);
        if (this.shapeType == ShapeType.POLYGONZ) {
            buffer.skip(16);
            for (int t = 0; t < numPoints; ++t) {
                coords.setOrdinate(t, 2, buffer.getDouble());
            }
        }
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            int ringLength = coords.getCoordinate(offset).equals((Object)coords.getCoordinate(offset + length - 1)) ? length : length + 1;
            CoordinateSequence csRing = this.geometryFactory.getCoordinateSequenceFactory().create(ringLength, 3);
            for (int i = 0; i < length; ++i) {
                csRing.setOrdinate(i, 0, coords.getOrdinate(offset, 0));
                csRing.setOrdinate(i, 1, coords.getOrdinate(offset, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(i, 2, coords.getOrdinate(offset, 2));
                }
                ++offset;
            }
            if (ringLength > length) {
                csRing.setOrdinate(length, 0, csRing.getOrdinate(0, 0));
                csRing.setOrdinate(length, 1, csRing.getOrdinate(0, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(length, 2, csRing.getOrdinate(0, 2));
                }
            }
            if (csRing.size() != 0 && csRing.size() <= 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(csRing);
            if (PolygonHandler.isCCW(csRing)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.isEmpty()) {
            return this.createMulti(((LinearRing)holes.get(0)).reverse());
        }
        List<List<LinearRing>> holesForShells = this.assignHolesToShells(shells, holes);
        return this.buildGeometries(shells, holes, holesForShells);
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        double hiy = ring.getOrdinate(0, 1);
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            if (!(ring.getOrdinate(i, 1) > hiy)) continue;
            hiy = ring.getOrdinate(i, 1);
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (PolygonHandler.equals2D(ring, iPrev, hiIndex) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (PolygonHandler.equals2D(ring, iNext = (iNext + 1) % nPts, hiIndex) && iNext != hiIndex) {
        }
        if (PolygonHandler.equals2D(ring, iPrev, hiIndex) || PolygonHandler.equals2D(ring, iNext, hiIndex) || PolygonHandler.equals2D(ring, iPrev, iNext)) {
            return false;
        }
        int disc = PolygonHandler.computeOrientation(ring, iPrev, hiIndex, iNext);
        boolean isCCW = false;
        isCCW = disc == 0 ? ring.getOrdinate(iPrev, 0) > ring.getOrdinate(iNext, 0) : disc > 0;
        return isCCW;
    }

    private static boolean equals2D(CoordinateSequence cs, int i, int j) {
        return cs.getOrdinate(i, 0) == cs.getOrdinate(j, 0) && cs.getOrdinate(i, 1) == cs.getOrdinate(j, 1);
    }

    public static int computeOrientation(CoordinateSequence cs, int p1, int p2, int q) {
        double p1x = cs.getOrdinate(p1, 0);
        double p1y = cs.getOrdinate(p1, 1);
        double p2x = cs.getOrdinate(p2, 0);
        double p2y = cs.getOrdinate(p2, 1);
        double qx = cs.getOrdinate(q, 0);
        double qy = cs.getOrdinate(q, 1);
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        double dx2 = qx - p2x;
        double dy2 = qy - p2y;
        return RobustDeterminant.signOfDet2x2((double)dx1, (double)dy1, (double)dx2, (double)dy2);
    }

    private CoordinateSequence readCoordinates(ReadBufferManager buffer, int numPoints, int dimensions) throws IOException {
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(numPoints, dimensions);
        for (int t = 0; t < numPoints; ++t) {
            cs.setOrdinate(t, 0, buffer.getDouble());
            cs.setOrdinate(t, 1, buffer.getDouble());
        }
        return cs;
    }

    private Geometry buildGeometries(List<LinearRing> shells, List<LinearRing> holes, List<List<LinearRing>> holesForShells) {
        int i;
        Polygon[] polygons = !shells.isEmpty() ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (i = 0; i < shells.size(); ++i) {
            List<LinearRing> hole = holesForShells.get(i);
            polygons[i] = this.geometryFactory.createPolygon(shells.get(i), hole.toArray(new LinearRing[0]));
        }
        if (shells.isEmpty()) {
            int ii = holes.size();
            for (i = 0; i < ii; ++i) {
                LinearRing hole = holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(hole.reverse(), new LinearRing[0]);
            }
        }
        return this.geometryFactory.createMultiPolygon(polygons);
    }

    List<List<LinearRing>> assignHolesToShells(List<LinearRing> shells, List<LinearRing> holes) {
        int i;
        ArrayList<List<LinearRing>> holesForShells = new ArrayList<List<LinearRing>>(shells.size());
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || CoordinatesUtils.contains(coordList, testPt))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                shells.add(testRing.reverse());
                holesForShells.add(new ArrayList());
                continue;
            }
            ((List)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, new ArrayList<LinearRing>(0));
    }

    private MultiPolygon createMulti(LinearRing single, List<LinearRing> holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[0]))});
    }

    @Override
    public void write(WriteBufferManager buffer, Geometry geometry) throws IOException {
        int t;
        if (geometry.getDimension() != 2) {
            throw new IllegalArgumentException("Only Polygon and MultiPolygon are managed by the shapefile driver");
        }
        Envelope box = geometry.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int nrings = 0;
        geometry.normalize();
        int size = geometry.getNumGeometries();
        for (int t2 = 0; t2 < size; ++t2) {
            Polygon p = (Polygon)geometry.getGeometryN(t2);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        for (int t3 = 0; t3 < size; ++t3) {
            Polygon p = (Polygon)geometry.getGeometryN(t3);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            for (int v = 0; v < p.getNumInteriorRing(); ++v) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
            }
        }
        int npoints = geometry.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        for (int t4 = 0; t4 < nrings; ++t4) {
            buffer.putInt(count);
            count += pointsPerRing[t4];
        }
        Coordinate[] coords = geometry.getCoordinates();
        for (t = 0; t < coords.length; ++t) {
            buffer.putDouble(coords[t].x);
            buffer.putDouble(coords[t].y);
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            double[] zExtreame = CoordinatesUtils.zMinMax(coords);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t5 = 0; t5 < npoints; ++t5) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

