/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.fgb;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.Column;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.FileDriver;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.fgb.FGBEngine;
import org.h2gis.functions.io.fgb.FGBWriteDriver;
import org.h2gis.functions.io.fgb.fileTable.FGBDriver;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class FGBDriverFunction
implements DriverFunction {
    private static final int BATCH_MAX_SIZE = 100;
    public static String DESCRIPTION = "FlatGeoBuffer";

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"fgb"};
    }

    public String[] getExportFormats() {
        return new String[]{"fgb"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("fgb")) {
            return "FlatGeobuf";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equals("fgb");
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, "", deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String options, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        FGBWriteDriver fgbWriteDriver = new FGBWriteDriver(connection);
        if (options != null) {
            String[] keyValuePairs;
            for (String pair : keyValuePairs = StringUtils.arraySplit((String)options, (char)' ', (boolean)false)) {
                int index = pair.indexOf(61);
                String key = StringUtils.trimSubstring((String)pair, (int)0, (int)index);
                String value = pair.substring(index + 1);
                if (key.equalsIgnoreCase("createIndex")) {
                    fgbWriteDriver.setCreateIndex(Boolean.parseBoolean(value));
                    continue;
                }
                if (!key.equalsIgnoreCase("nodeSize")) continue;
                fgbWriteDriver.setPackedRTreeNodeSize(Short.parseShort(value.trim()));
            }
        }
        try {
            fgbWriteDriver.write(progress, tableReference, fileName, deleteFiles);
            return new String[]{fileName.getAbsolutePath()};
        }
        catch (IOException | SQLException ex) {
            throw new SQLException(ex);
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, options, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, "", false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, options, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, "", deleteTables, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        if (FileUtilities.isFileImportable((File)fileName, (String)"fgb")) {
            String sqlTableName = TableLocation.parse((String)tableReference, (DBTypes)dbType).toString();
            try (Statement st = connection.createStatement();){
                if (deleteTables) {
                    st.execute("DROP TABLE IF EXISTS " + sqlTableName);
                } else if (JDBCUtilities.tableExists((Connection)connection, (String)tableReference)) {
                    throw new SQLException("Table " + tableReference + " already exists in the database");
                }
                FGBEngine fgbEngine = new FGBEngine();
                FileDriver fgbDriver = fgbEngine.createDriver(fileName, (List)Collections.singletonList(options));
                fgbDriver.setCacheRowAddress(false);
                CreateTableData createTableData = new CreateTableData();
                fgbEngine.feedCreateTableData((FGBDriver)fgbDriver, createTableData);
                StringBuilder createTableQuery = new StringBuilder("CREATE TABLE ");
                createTableQuery.append(sqlTableName);
                createTableQuery.append("(");
                boolean firstColumn = true;
                for (Object column : createTableData.columns) {
                    if (!firstColumn) {
                        createTableQuery.append(",");
                    }
                    firstColumn = false;
                    createTableQuery.append(column.getCreateSQL());
                }
                createTableQuery.append(")");
                st.execute(createTableQuery.toString());
                StringBuilder preparedStatementQuery = new StringBuilder("INSERT INTO ");
                preparedStatementQuery.append(sqlTableName);
                preparedStatementQuery.append("(");
                firstColumn = true;
                for (Column column : createTableData.columns) {
                    if (!firstColumn) {
                        preparedStatementQuery.append(",");
                    }
                    firstColumn = false;
                    ParserUtil.quoteIdentifier((StringBuilder)preparedStatementQuery, (String)column.getName(), (int)0);
                }
                preparedStatementQuery.append(") VALUES (");
                preparedStatementQuery.append(String.join((CharSequence)",", Collections.nCopies(createTableData.columns.size(), "?")));
                preparedStatementQuery.append(")");
                int columnCount = fgbDriver.getFieldCount();
                ProgressVisitor rowCopyProgress = progress.subProcess((int)fgbDriver.getRowCount());
                long batchSize = 0L;
                connection.setAutoCommit(false);
                try (PreparedStatement pst = connection.prepareStatement(preparedStatementQuery.toString());){
                    for (long rowId = 0L; rowId < fgbDriver.getRowCount(); ++rowId) {
                        for (int columnId = 0; columnId < columnCount; ++columnId) {
                            pst.setObject(columnId + 1, fgbDriver.getField(rowId, columnId));
                        }
                        pst.addBatch();
                        rowCopyProgress.endStep();
                        if (++batchSize < 100L) continue;
                        pst.executeBatch();
                        connection.commit();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if (batchSize > 0L) {
                        pst.executeBatch();
                        connection.commit();
                        pst.clearBatch();
                    }
                }
                String[] stringArray = new String[]{sqlTableName};
                return stringArray;
            }
        }
        return null;
    }
}

