/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryFeatureUtils {
    static int maxdecimaldigits = 9;

    public static ArrayList toList(Connection connection, String query) throws SQLException {
        return GeometryFeatureUtils.toList(connection, query, maxdecimaldigits);
    }

    /*
     * Loose catch block
     */
    public static ArrayList<LinkedHashMap> toList(Connection connection, String query, int maxdecimaldigits) throws SQLException {
        if (connection == null || query == null) {
            throw new SQLException("Unable to get a JSON list");
        }
        try (Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery(query);){
                ArrayList<LinkedHashMap> arrayList = GeometryFeatureUtils.toList(resultSet, maxdecimaldigits);
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static ArrayList<LinkedHashMap> toList(ResultSet resultSet, int maxdecimaldigits) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        String firstGeom = null;
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String columnTypeName = metaData.getColumnTypeName(i);
            if (firstGeom == null && columnTypeName.toLowerCase().startsWith("geometry")) {
                firstGeom = metaData.getColumnName(i);
                continue;
            }
            columns.add(metaData.getColumnName(i));
        }
        int size = columns.size();
        ArrayList<LinkedHashMap> features = new ArrayList<LinkedHashMap>();
        while (resultSet.next()) {
            if (firstGeom != null) {
                LinkedHashMap<String, Object> feature = new LinkedHashMap<String, Object>();
                feature.put("type", "Feature");
                feature.putAll(GeometryFeatureUtils.toMap((Geometry)resultSet.getObject(firstGeom), maxdecimaldigits));
                if (size > 0) {
                    feature.put("properties", GeometryFeatureUtils.getProperties(resultSet, columns));
                }
                features.add(feature);
                continue;
            }
            features.add(GeometryFeatureUtils.getProperties(resultSet, columns));
        }
        return features;
    }

    public static LinkedHashMap getProperties(ResultSet resultSet, Collection<String> columns) throws Exception {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String column : columns) {
            properties.put(column, resultSet.getObject(column));
        }
        return properties;
    }

    public static LinkedHashMap toMap(Geometry geom) {
        return GeometryFeatureUtils.toMap(geom, 9);
    }

    public static LinkedHashMap toMap(Geometry geom, int maxdecimaldigits) {
        LinkedHashMap<String, LinkedHashMap> geometry_map = new LinkedHashMap<String, LinkedHashMap>();
        if (geom == null) {
            geometry_map.put("geometry", null);
        } else if (geom instanceof Point) {
            geometry_map.put("geometry", GeometryFeatureUtils.toPoint((Point)geom, maxdecimaldigits));
        } else if (geom instanceof LineString) {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonLineString((LineString)geom, maxdecimaldigits));
        } else if (geom instanceof Polygon) {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonPolygon((Polygon)geom, maxdecimaldigits));
        } else if (geom instanceof MultiPoint) {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonMultiPoint((MultiPoint)geom, maxdecimaldigits));
        } else if (geom instanceof MultiLineString) {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonMultiLineString((MultiLineString)geom, maxdecimaldigits));
        } else if (geom instanceof MultiPolygon) {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonMultiPolygon((MultiPolygon)geom, maxdecimaldigits));
        } else {
            geometry_map.put("geometry", GeometryFeatureUtils.toGeojsonGeometryCollection((GeometryCollection)geom, maxdecimaldigits));
        }
        return geometry_map;
    }

    public static LinkedHashMap toPoint(Point point, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "Point");
        Coordinate coord = point.getCoordinate();
        ArrayList<Double> coord_ = new ArrayList<Double>();
        coord_.add(CoordinateUtils.round(coord.x, maxdecimaldigits));
        coord_.add(CoordinateUtils.round(coord.y, maxdecimaldigits));
        if (!Double.isNaN(coord.z)) {
            coord_.add(CoordinateUtils.round(coord.z, maxdecimaldigits));
        }
        geometry_values.put("coordinates", coord_);
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonLineString(LineString lineString, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "LineString");
        geometry_values.put("coordinates", GeometryFeatureUtils.toGeojsonCoordinates(lineString.getCoordinates(), maxdecimaldigits));
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonPolygon(Polygon polygon, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "Polygon");
        ArrayList<ArrayList> allCoords = new ArrayList<ArrayList>();
        allCoords.add(GeometryFeatureUtils.toGeojsonCoordinates(polygon.getExteriorRing().getCoordinates(), maxdecimaldigits));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            allCoords.add(GeometryFeatureUtils.toGeojsonCoordinates(polygon.getInteriorRingN(i).getCoordinates(), maxdecimaldigits));
        }
        geometry_values.put("coordinates", allCoords);
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonMultiPoint(MultiPoint multiPoint, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "MultiPoint");
        geometry_values.put("coordinates", GeometryFeatureUtils.toGeojsonCoordinates(multiPoint.getCoordinates(), maxdecimaldigits));
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonMultiLineString(MultiLineString multiLineString, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "MultiLineString");
        int size = multiLineString.getNumGeometries();
        ArrayList<ArrayList> allCoords = new ArrayList<ArrayList>();
        for (int i = 0; i < size; ++i) {
            allCoords.add(GeometryFeatureUtils.toGeojsonCoordinates(multiLineString.getGeometryN(i).getCoordinates(), maxdecimaldigits));
        }
        geometry_values.put("coordinates", allCoords);
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonMultiPolygon(MultiPolygon multiPolygon, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "MultiPolygon");
        int size = multiPolygon.getNumGeometries();
        ArrayList allCoords = new ArrayList();
        for (int i = 0; i < size; ++i) {
            ArrayList<ArrayList> pCoords = new ArrayList<ArrayList>();
            Polygon p = (Polygon)multiPolygon.getGeometryN(i);
            pCoords.add(GeometryFeatureUtils.toGeojsonCoordinates(p.getExteriorRing().getCoordinates(), maxdecimaldigits));
            int size_p = p.getNumInteriorRing();
            for (int j = 0; j < size_p; ++j) {
                pCoords.add(GeometryFeatureUtils.toGeojsonCoordinates(p.getInteriorRingN(j).getCoordinates(), maxdecimaldigits));
            }
            allCoords.add(pCoords);
        }
        geometry_values.put("coordinates", allCoords);
        return geometry_values;
    }

    public static LinkedHashMap toGeojsonGeometryCollection(GeometryCollection geometryCollection, int maxdecimaldigits) {
        LinkedHashMap<String, Object> geometry_values = new LinkedHashMap<String, Object>();
        geometry_values.put("type", "GeometryCollection");
        ArrayList<LinkedHashMap> geometries = new ArrayList<LinkedHashMap>();
        int size = geometryCollection.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry geom = geometryCollection.getGeometryN(i);
            if (geom instanceof Point) {
                geometries.add(GeometryFeatureUtils.toPoint((Point)geom, maxdecimaldigits));
                continue;
            }
            if (geom instanceof LineString) {
                geometries.add(GeometryFeatureUtils.toGeojsonLineString((LineString)geom, maxdecimaldigits));
                continue;
            }
            if (!(geom instanceof Polygon)) continue;
            geometries.add(GeometryFeatureUtils.toGeojsonPolygon((Polygon)geom, maxdecimaldigits));
        }
        geometry_values.put("geometries", geometries);
        return geometry_values;
    }

    public static ArrayList toGeojsonCoordinates(Coordinate[] coords, int maxdecimaldigits) {
        ArrayList<ArrayList> coords_ = new ArrayList<ArrayList>();
        for (int i = 0; i < coords.length; ++i) {
            coords_.add(GeometryFeatureUtils.toGeojsonCoordinate(coords[i], maxdecimaldigits));
        }
        return coords_;
    }

    public static ArrayList toGeojsonCoordinate(Coordinate coord, int maxdecimaldigits) {
        ArrayList<Double> coord_ = new ArrayList<Double>();
        coord_.add(CoordinateUtils.round(coord.x, maxdecimaldigits));
        coord_.add(CoordinateUtils.round(coord.y, maxdecimaldigits));
        if (!Double.isNaN(coord.z)) {
            coord_.add(CoordinateUtils.round(coord.z, maxdecimaldigits));
        }
        return coord_;
    }
}

