/*
 * Decompiled with CFR 0.152.
 */
package org.cts.cs;

import org.cts.cs.Extent;

public class GeographicExtent
implements Extent {
    public static final GeographicExtent WORLD = new GeographicExtent("World", -90.0, 90.0, -180.0, 180.0);
    private final String name;
    private final double westernBound;
    private final double easternBound;
    private final double southernBound;
    private final double northernBound;
    private final double modulo;

    public GeographicExtent(String name, double southernBound, double northernBound, double westernBound, double easternBound) {
        this(name, southernBound, northernBound, westernBound, easternBound, 360.0);
    }

    public GeographicExtent(String name, double southernBound, double northernBound, double westernBound, double easternBound, double modulo) {
        this.name = name;
        this.southernBound = southernBound;
        this.northernBound = northernBound;
        this.westernBound = (westernBound + modulo / 2.0) % modulo - modulo / 2.0;
        this.easternBound = easternBound < this.westernBound ? easternBound + modulo : easternBound;
        this.modulo = modulo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getWesternBound() {
        return this.westernBound;
    }

    public double getEasternBound() {
        return this.easternBound;
    }

    public double getSouthernBound() {
        return this.southernBound;
    }

    public double getNorthernBound() {
        return this.northernBound;
    }

    public double getModulo() {
        return this.modulo;
    }

    public boolean isInside(double lat, double lon) {
        double lon_;
        double d = lon_ = lon < this.westernBound ? lon + this.modulo : lon;
        if (lat < this.southernBound || lat > this.northernBound) {
            return false;
        }
        return !(lon_ < this.westernBound) && !(lon_ > this.easternBound);
    }

    @Override
    public boolean isInside(double[] coord) {
        return this.isInside(coord[0], coord[1]);
    }

    public String toString() {
        return this.name + " lat[" + this.southernBound + " to " + this.northernBound + "] lon[" + this.westernBound + " to " + this.easternBound + "]";
    }
}

