/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor;

import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class DynamicCompilerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<Diagnostic<? extends JavaFileObject>> diagnostics;

    public DynamicCompilerException(String message, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        super(message);
        this.diagnostics = diagnostics;
    }

    public DynamicCompilerException(Throwable cause, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        super(cause);
        this.diagnostics = diagnostics;
    }

    private String getErrors() {
        StringBuilder buf = new StringBuilder();
        if (this.diagnostics != null) {
            for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnostics) {
                String packagePath = this.getPackagePath(diagnostic);
                String diagnosticString = diagnostic.toString();
                if (packagePath == null) {
                    buf.append(diagnosticString).append("\n");
                    continue;
                }
                if (diagnosticString.startsWith(packagePath)) {
                    buf.append(diagnosticString).append("\n");
                    continue;
                }
                buf.append(packagePath).append(diagnosticString).append("\n");
            }
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private String getPackagePath(Diagnostic<? extends JavaFileObject> diagnostic) {
        try {
            int end;
            String source = diagnostic.getSource().getCharContent(true).toString();
            if (source.startsWith("package ") && (end = source.indexOf(";")) > 0) {
                return "/" + source.substring("package ".length(), end).replace(".", "/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ":\n\n" + this.getErrors();
    }
}

