/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.noear.liquor.DynamicClassLoader;
import org.noear.liquor.DynamicCompiler;
import org.noear.liquor.eval.CodeSpec;
import org.noear.liquor.eval.Evaluator;
import org.noear.liquor.eval.Execable;
import org.noear.liquor.eval.ExecuteException;
import org.noear.liquor.eval.LRUCache;
import org.noear.liquor.eval.ParamSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquorEvaluator
implements Evaluator {
    private static final Logger log = LoggerFactory.getLogger(LiquorEvaluator.class);
    private static final Evaluator instance = new LiquorEvaluator(null);
    private final DynamicCompiler compiler;
    private final DynamicClassLoader cachedClassLoader;
    private DynamicClassLoader tempClassLoader;
    private int tempCount = 0;
    private final List<String> globalImports = new ArrayList<String>();
    private final Map<CodeSpec, Execable> cachedMap;
    private final int cahceCapacity;
    private final AtomicLong nameIdx = new AtomicLong(0L);
    private final ReentrantLock lock = new ReentrantLock();

    public static Evaluator getInstance() {
        return instance;
    }

    public LiquorEvaluator(ClassLoader parentClassLoader) {
        this(parentClassLoader, 10000);
    }

    public LiquorEvaluator(ClassLoader parentClassLoader, int cahceCapacity) {
        this.compiler = new DynamicCompiler(parentClassLoader);
        this.cachedClassLoader = this.compiler.getClassLoader();
        this.tempClassLoader = this.compiler.newClassLoader();
        this.cahceCapacity = cahceCapacity;
        this.cachedMap = Collections.synchronizedMap(new LRUCache(cahceCapacity));
        this.globalImports.add(Map.class.getTypeName());
        this.globalImports.add(Execable.class.getTypeName());
        this.globalImports.add(ExecuteException.class.getTypeName());
    }

    protected Class<?> build(CodeSpec codeSpec) {
        boolean isCached = codeSpec.isCached();
        this.lock.lock();
        try {
            if (isCached) {
                this.compiler.setClassLoader(this.cachedClassLoader);
            } else {
                if (this.tempCount++ > this.cahceCapacity) {
                    this.tempClassLoader = this.compiler.newClassLoader();
                    this.tempCount = 0;
                }
                this.compiler.setClassLoader(this.tempClassLoader);
            }
            String clazzName = this.addSource(codeSpec);
            this.compiler.build();
            Class clazz = this.compiler.getClassLoader().loadClass(clazzName);
            return clazz;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<CodeSpec, Class<?>> build(List<CodeSpec> codeSpecs) {
        boolean isCached = codeSpecs.get(0).isCached();
        this.lock.lock();
        try {
            if (isCached) {
                this.compiler.setClassLoader(this.cachedClassLoader);
            } else {
                if (this.tempCount++ > this.cahceCapacity) {
                    this.tempClassLoader = this.compiler.newClassLoader();
                    this.tempCount = 0;
                }
                this.compiler.setClassLoader(this.tempClassLoader);
            }
            HashMap<CodeSpec, String> clazzNameMap = new HashMap<CodeSpec, String>();
            for (CodeSpec codeSpec : codeSpecs) {
                String clazzName = this.addSource(codeSpec);
                clazzNameMap.put(codeSpec, clazzName);
            }
            this.compiler.build();
            HashMap clazzMap = new HashMap();
            for (Map.Entry entry : clazzNameMap.entrySet()) {
                Class clazz = this.compiler.getClassLoader().loadClass((String)entry.getValue());
                clazzMap.put(entry.getKey(), clazz);
            }
            HashMap hashMap = clazzMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String addSource(CodeSpec codeSpec) {
        TreeSet<String> importBuilder = new TreeSet<String>();
        StringBuilder codeBuilder = new StringBuilder();
        for (String imp : this.globalImports) {
            importBuilder.add("import " + imp + ";\n");
        }
        for (String imp : codeSpec.getImports()) {
            importBuilder.add("import " + imp + ";\n");
        }
        if (codeSpec.getCode().contains("import ")) {
            BufferedReader reader = new BufferedReader(new StringReader(codeSpec.getCode()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String lineTrim = line.trim();
                    if (lineTrim.startsWith("import ")) {
                        importBuilder.add(lineTrim + "\n");
                        continue;
                    }
                    codeBuilder.append(line).append("\n");
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            codeBuilder.append(codeSpec.getCode());
        }
        String clazzName = "Execable$" + this.nameIdx.incrementAndGet();
        StringBuilder code = new StringBuilder();
        if (importBuilder.size() > 0) {
            for (String impCode : importBuilder) {
                code.append(impCode);
            }
            code.append("\n");
        }
        code.append("public class ").append(clazzName).append(" implements Execable {\n");
        code.append("  public Object exec(Map<String, Object> context) throws ExecuteException {\n");
        code.append("    try {\n");
        if (codeSpec.getReturnType() == null) {
            code.append("      execDo(context");
        } else {
            code.append("      return execDo(context");
        }
        code.append(");\n");
        code.append("    } catch(Throwable e) {\n");
        code.append("      throw new ExecuteException(e);\n");
        code.append("    }\n");
        if (codeSpec.getReturnType() == null) {
            code.append("    return null;\n");
        }
        code.append("  }\n\n");
        code.append("  public ");
        if (codeSpec.getReturnType() != null) {
            code.append(codeSpec.getReturnType().getTypeName());
        } else {
            code.append("void");
        }
        code.append(" execDo(Map<String, Object> _$$) throws Throwable\n");
        code.append("  {\n");
        if (codeSpec.getParameters() != null && codeSpec.getParameters().size() > 0) {
            for (ParamSpec ps : codeSpec.getParameters()) {
                Class<?> type = this.getParamType(ps.getType());
                code.append("    ").append(type.getTypeName()).append(" ").append(ps.getName()).append(" = ").append("(").append(type.getTypeName()).append(")_$$.get(\"").append(ps.getName()).append("\");").append("\n");
            }
        }
        if (codeSpec.getCode().indexOf(59) < 0) {
            if (codeSpec.getReturnType() == null) {
                code.append("    ").append(codeSpec.getCode()).append(";\n");
            } else {
                code.append("    return ").append(codeSpec.getCode()).append(";\n");
            }
        } else {
            code.append("    ").append((CharSequence)codeBuilder).append("\n");
        }
        code.append("  }\n");
        code.append("}");
        if (log.isDebugEnabled()) {
            log.debug("-- Liquor Class Start(" + clazzName + ") --\n" + code + "\n-- End(" + clazzName + ") --");
        }
        this.compiler.addSource(clazzName, code.toString());
        return clazzName;
    }

    private Class<?> getParamType(Class<?> type) {
        if (Modifier.isPublic(type.getModifiers())) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return Set.class;
        }
        if (Queue.class.isAssignableFrom(type)) {
            return Queue.class;
        }
        if (Iterator.class.isAssignableFrom(type)) {
            return Iterator.class;
        }
        if (Stream.class.isAssignableFrom(type)) {
            return Stream.class;
        }
        return type;
    }

    @Override
    @Deprecated
    public void printable(boolean printable) {
    }

    public void globalImports(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.globalImports.add(clz.getTypeName());
        }
    }

    public void globalImports(String ... imports) {
        for (String imp : imports) {
            this.globalImports.add(imp);
        }
    }

    @Override
    public Execable compile(CodeSpec codeSpec) {
        if (codeSpec == null) {
            throw new IllegalArgumentException("The codeSpec parameter is null");
        }
        if (!codeSpec.isCached()) {
            return this.clazzToExecable(this.build(codeSpec));
        }
        return this.cachedMap.computeIfAbsent(codeSpec, k -> this.clazzToExecable(this.build(codeSpec)));
    }

    private Execable clazzToExecable(Class<?> clazz) {
        try {
            return (Execable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Map<CodeSpec, Execable> compile(List<CodeSpec> codeSpecs) {
        if (codeSpecs == null || codeSpecs.size() == 0) {
            throw new IllegalArgumentException("The codeSpecs parameter is empty");
        }
        HashMap<CodeSpec, Execable> execableMap = new HashMap<CodeSpec, Execable>();
        if (!codeSpecs.get(0).isCached()) {
            for (Map.Entry<CodeSpec, Class<?>> entry : this.build(codeSpecs).entrySet()) {
                execableMap.put(entry.getKey(), this.clazzToExecable(entry.getValue()));
            }
        } else {
            ArrayList<CodeSpec> codeSpecs2 = new ArrayList<CodeSpec>();
            for (CodeSpec codeSpec : codeSpecs) {
                Execable execable2 = this.cachedMap.get(codeSpec);
                if (execable2 == null) {
                    codeSpecs2.add(codeSpec);
                    continue;
                }
                execableMap.put(codeSpec, execable2);
            }
            for (Map.Entry entry : this.build(codeSpecs).entrySet()) {
                Execable execable1 = this.clazzToExecable((Class)entry.getValue());
                this.cachedMap.put((CodeSpec)entry.getKey(), execable1);
                execableMap.put((CodeSpec)entry.getKey(), execable1);
            }
        }
        return execableMap;
    }

    @Override
    public Object eval(CodeSpec codeSpec, Map<String, Object> context) {
        if (codeSpec == null) {
            throw new IllegalArgumentException("The codeSpec parameter is null");
        }
        if (codeSpec.getParameters().size() == 0 && context != null && context.size() > 0) {
            codeSpec.parameters(context);
        }
        try {
            return this.compile(codeSpec).exec(context);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecuteException(e);
        }
    }
}

