
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SupportVectors" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Coefficients"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="alternateTargetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors",
    "coefficients"
})
@XmlRootElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_2")
public class SupportVectorMachine
    extends PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "targetCategory")
    @Added(Version.PMML_3_1)
    protected String targetCategory;
    @XmlAttribute(name = "alternateTargetCategory")
    @Added(Version.PMML_4_0)
    protected String alternateTargetCategory;
    @XmlAttribute(name = "threshold")
    @Added(Version.PMML_4_0)
    protected Double threshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_2")
    protected SupportVectors supportVectors;
    @XmlElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected Coefficients coefficients;

    public SupportVectorMachine() {
        super();
    }

    public SupportVectorMachine(final Coefficients coefficients) {
        super();
        this.coefficients = coefficients;
    }

    /**
     * Gets the value of the targetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetCategory() {
        return targetCategory;
    }

    /**
     * Sets the value of the targetCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetCategory(String value) {
        this.targetCategory = value;
    }

    /**
     * Gets the value of the alternateTargetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlternateTargetCategory() {
        return alternateTargetCategory;
    }

    /**
     * Sets the value of the alternateTargetCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlternateTargetCategory(String value) {
        this.alternateTargetCategory = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        return threshold;
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the supportVectors property.
     * 
     * @return
     *     possible object is
     *     {@link SupportVectors }
     *     
     */
    public SupportVectors getSupportVectors() {
        return supportVectors;
    }

    /**
     * Sets the value of the supportVectors property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupportVectors }
     *     
     */
    public void setSupportVectors(SupportVectors value) {
        this.supportVectors = value;
    }

    /**
     * Gets the value of the coefficients property.
     * 
     * @return
     *     possible object is
     *     {@link Coefficients }
     *     
     */
    public Coefficients getCoefficients() {
        return coefficients;
    }

    /**
     * Sets the value of the coefficients property.
     * 
     * @param value
     *     allowed object is
     *     {@link Coefficients }
     *     
     */
    public void setCoefficients(Coefficients value) {
        this.coefficients = value;
    }

    public SupportVectorMachine withTargetCategory(String value) {
        setTargetCategory(value);
        return this;
    }

    public SupportVectorMachine withAlternateTargetCategory(String value) {
        setAlternateTargetCategory(value);
        return this;
    }

    public SupportVectorMachine withThreshold(Double value) {
        setThreshold(value);
        return this;
    }

    public SupportVectorMachine withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public SupportVectorMachine withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public SupportVectorMachine withSupportVectors(SupportVectors value) {
        setSupportVectors(value);
        return this;
    }

    public SupportVectorMachine withCoefficients(Coefficients value) {
        setCoefficients(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.supportVectors!= null)) {
            status = this.supportVectors.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.coefficients!= null)) {
            status = this.coefficients.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
