
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Neuron" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfNeurons" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *       &lt;attribute name="activationFunction" type="{http://www.dmg.org/PMML-4_2}ACTIVATION-FUNCTION" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="width" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="altitude" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="normalizationMethod" type="{http://www.dmg.org/PMML-4_2}NN-NORMALIZATION-METHOD" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neurons"
})
@XmlRootElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_2")
public class NeuralLayer
    extends PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "numberOfNeurons")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    protected Integer numberOfNeurons;
    @XmlAttribute(name = "activationFunction")
    protected ActivationFunctionType activationFunction;
    @XmlAttribute(name = "threshold")
    protected Double threshold;
    @XmlAttribute(name = "width")
    protected Double width;
    @XmlAttribute(name = "altitude")
    protected Double altitude;
    @XmlAttribute(name = "normalizationMethod")
    protected NnNormalizationMethodType normalizationMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "Neuron", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected List<Neuron> neurons;

    public NeuralLayer() {
        super();
    }

    public NeuralLayer(final List<Neuron> neurons) {
        super();
        this.neurons = neurons;
    }

    /**
     * Gets the value of the numberOfNeurons property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfNeurons() {
        return numberOfNeurons;
    }

    /**
     * Sets the value of the numberOfNeurons property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfNeurons(Integer value) {
        this.numberOfNeurons = value;
    }

    /**
     * Gets the value of the activationFunction property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationFunctionType }
     *     
     */
    public ActivationFunctionType getActivationFunction() {
        return activationFunction;
    }

    /**
     * Sets the value of the activationFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivationFunctionType }
     *     
     */
    public void setActivationFunction(ActivationFunctionType value) {
        this.activationFunction = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        return threshold;
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setWidth(Double value) {
        this.width = value;
    }

    /**
     * Gets the value of the altitude property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAltitude() {
        return altitude;
    }

    /**
     * Sets the value of the altitude property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setAltitude(Double value) {
        this.altitude = value;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NnNormalizationMethodType getNormalizationMethod() {
        return normalizationMethod;
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public void setNormalizationMethod(NnNormalizationMethodType value) {
        this.normalizationMethod = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the neurons property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neurons property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeurons().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Neuron }
     * 
     * 
     */
    public List<Neuron> getNeurons() {
        if (neurons == null) {
            neurons = new ArrayList<Neuron>();
        }
        return this.neurons;
    }

    public NeuralLayer withNumberOfNeurons(Integer value) {
        setNumberOfNeurons(value);
        return this;
    }

    public NeuralLayer withActivationFunction(ActivationFunctionType value) {
        setActivationFunction(value);
        return this;
    }

    public NeuralLayer withThreshold(Double value) {
        setThreshold(value);
        return this;
    }

    public NeuralLayer withWidth(Double value) {
        setWidth(value);
        return this;
    }

    public NeuralLayer withAltitude(Double value) {
        setAltitude(value);
        return this;
    }

    public NeuralLayer withNormalizationMethod(NnNormalizationMethodType value) {
        setNormalizationMethod(value);
        return this;
    }

    public NeuralLayer withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public NeuralLayer withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public NeuralLayer withNeurons(Neuron... values) {
        if (values!= null) {
            for (Neuron value: values) {
                getNeurons().add(value);
            }
        }
        return this;
    }

    public NeuralLayer withNeurons(Collection<Neuron> values) {
        if (values!= null) {
            getNeurons().addAll(values);
        }
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public boolean hasNeurons() {
        return ((this.neurons!= null)&&(this.neurons.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.neurons!= null))&&(i<this.neurons.size())); i ++) {
            status = this.neurons.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
