/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.file;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.InputStream;
import java.util.function.Consumer;
import org.jetlinks.core.command.AbstractStreamCommand;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.sdk.server.file.FileInfo;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StreamUploadFileCommand
extends AbstractStreamCommand<ByteBuf, FileInfo, StreamUploadFileCommand> {
    public String getFileName() {
        return (String)this.readable().get("fileName");
    }

    public StreamUploadFileCommand withFileName(String name) {
        return (StreamUploadFileCommand)this.with("fileName", name);
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, InputStream data, int bufferSize, Consumer<StreamUploadFileCommand> consumer) {
        return Mono.defer(() -> StreamUploadFileCommand.execute0(cmd, data, bufferSize, consumer));
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, Flux<ByteBuf> body, Consumer<StreamUploadFileCommand> consumer) {
        StreamUploadFileCommand command = new StreamUploadFileCommand();
        consumer.accept(command);
        command.withStream(body);
        return ((Flux)cmd.execute((Command)command)).take(1L).singleOrEmpty();
    }

    private static Mono<FileInfo> execute0(CommandSupport cmd, InputStream data, int bufferSize, Consumer<StreamUploadFileCommand> consumer) {
        return StreamUploadFileCommand.execute(cmd, (Flux<ByteBuf>)DataBufferUtils.readInputStream(() -> data, (DataBufferFactory)new NettyDataBufferFactory(ByteBufAllocator.DEFAULT), (int)bufferSize).subscribeOn(Schedulers.boundedElastic()).map(buffer -> ((NettyDataBuffer)buffer).getNativeBuffer()), consumer);
    }
}

