/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.commons.cmd;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.core.param.UpdateParam;
import org.hswebframework.ezorm.rdb.mapping.DSLUpdate;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class UpdateCommand<T>
extends AbstractCommand<Mono<Integer>, UpdateCommand<T>> {
    public static final String PARAMETER_DATA = "data";
    public static final String PARAMETER_TERMS = "terms";

    public UpdateCommand<T> dsl(T data, Consumer<Update<T, UpdateParam<T>>> consumer) {
        Update update = Update.of(data);
        consumer.accept(update);
        this.with(PARAMETER_DATA, update.getParam().getData());
        this.with(PARAMETER_TERMS, update.getParam().getTerms());
        return (UpdateCommand)this.castSelf();
    }

    public QueryParamEntity toQuery() {
        List<Term> terms = this.getTerms();
        QueryParamEntity param = QueryParamEntity.of();
        if (terms != null) {
            terms.forEach(arg_0 -> ((QueryParamEntity)param).addTerm(arg_0));
        }
        return param;
    }

    public List<Term> getTerms() {
        Object terms = this.readable().get(PARAMETER_TERMS);
        return ConverterUtils.convertTerms(terms);
    }

    public UpdateCommand<T> setTerms(List<Term> terms) {
        return (UpdateCommand)this.with(PARAMETER_TERMS, terms);
    }

    public <E extends T, U extends DSLUpdate<E, ?>> U applyUpdate(U update, Function<Object, E> mapper) {
        UpdateParam<E> param = this.toParameter(mapper);
        Object data = param.getData();
        update.set(data);
        if (data instanceof Map) {
            ((Map)data).forEach((key, value) -> {
                if (value == null) {
                    if (key.equals("id")) {
                        throw new BusinessException("error.update_id_can_not_be_null");
                    }
                    update.setNull(String.valueOf(key));
                }
            });
        }
        for (Term term : param.getTerms()) {
            update.accept(term);
        }
        return update;
    }

    public <E> UpdateParam<E> toParameter(Function<Object, E> mapper) {
        Object data = this.readable().get(PARAMETER_DATA);
        Object terms = this.readable().get(PARAMETER_TERMS);
        Assert.isInstanceOf(Map.class, data, (String)"illegal 'data' format");
        Assert.notNull(terms, (String)"'terms' can not be null");
        UpdateParam param = new UpdateParam(mapper.apply(data));
        param.setTerms(ConverterUtils.convertTerms(terms));
        return param;
    }

    public static <T> CommandHandler<UpdateCommand<T>, Mono<Integer>> createHandler(Consumer<SimpleFunctionMetadata> custom, Function<UpdateCommand<T>, Mono<Integer>> handler) {
        return CommandHandler.of(() -> {
            SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
            metadata.setId(CommandUtils.getCommandIdByType(UpdateCommand.class));
            metadata.setName("\u66f4\u65b0\u6570\u636e");
            metadata.setDescription("\u6309\u6761\u4ef6\u66f4\u65b0\u6570\u636e,\u66f4\u65b0\u6761\u4ef6\u4e0d\u5f97\u4e3a\u7a7a");
            metadata.setOutput((DataType)IntType.GLOBAL);
            custom.accept(metadata);
            return metadata;
        }, (cmd, ignore) -> (Mono)handler.apply((UpdateCommand)((Object)cmd)), UpdateCommand::new);
    }
}

