/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scope;

import java.util.Arrays;
import java.util.Map;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.rule.engine.api.scope.PersistenceScope;
import org.jetlinks.rule.engine.api.scope.ScopeCounter;
import org.jetlinks.rule.engine.cluster.scope.ClusterScopeCounter;
import reactor.core.publisher.Mono;

class ClusterPersistenceScope
implements PersistenceScope {
    protected final String id;
    protected final ClusterManager clusterManager;

    protected String getKey() {
        return "rule-engine:" + this.id;
    }

    public Mono<Void> putAll(Map<String, Object> keyValue) {
        return this.getCache().putAll(keyValue).then();
    }

    protected ClusterCache<String, Object> getCache() {
        return this.clusterManager.getCache(this.getKey());
    }

    public Mono<Map<String, Object>> all(String ... key) {
        if (key.length == 0) {
            return this.getCache().entries().collectMap(Map.Entry::getKey, Map.Entry::getValue);
        }
        return this.getCache().get(Arrays.asList(key)).collectMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public Mono<Void> put(String key, Object value) {
        if (value == null) {
            return this.getCache().remove((Object)key).then();
        }
        return this.getCache().put((Object)key, value).then();
    }

    public Mono<Object> remove(String key) {
        return this.getCache().get((Object)key).flatMap(v -> this.getCache().remove((Object)key).thenReturn(v));
    }

    public Mono<Object> get(String key) {
        return this.getCache().get((Object)key);
    }

    public Mono<Object> getAndRemove(String key) {
        return this.getCache().getAndRemove((Object)key);
    }

    public Mono<Void> clear() {
        return this.getCache().clear();
    }

    public ScopeCounter counter(String key) {
        return new ClusterScopeCounter(this.clusterManager.getCounter(this.getKey() + ":counter"));
    }

    public ClusterPersistenceScope(String id, ClusterManager clusterManager) {
        this.id = id;
        this.clusterManager = clusterManager;
    }
}

