/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.server.monitor;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import org.jetlinks.core.server.monitor.GatewayServerMetrics;
import org.jetlinks.core.server.session.DeviceSession;

public class MicrometerGatewayServerMetrics
implements GatewayServerMetrics {
    private String serverId;
    private MeterRegistry registry;

    public MicrometerGatewayServerMetrics(String serverId) {
        this(serverId, null);
    }

    public MicrometerGatewayServerMetrics(String serverId, MeterRegistry registry) {
        this.serverId = serverId;
        if (registry == null) {
            registry = Metrics.globalRegistry;
        }
        this.registry = registry;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void reportSession(String transport, int sessionTotal) {
        Gauge.builder((String)"gateway-server-session", (Object)sessionTotal, Number::doubleValue).tag("transport", transport).tag("server", this.getServerId()).description("\u5f53\u524d" + transport + "\u4f1a\u8bdd\u6570\u91cf").register(this.registry);
    }

    public void newConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void acceptedConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment(-1.0);
        this.registry.counter("gateway-server-requests-accepts", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void rejectedConnection(String transport) {
        this.registry.counter("gateway-server-requests-currents", new String[]{"transport", transport, "server", this.getServerId()}).increment(-1.0);
        this.registry.counter("gateway-server-requests-rejects", new String[]{"transport", transport, "server", this.getServerId()}).increment();
    }

    public void receiveFromDeviceMessage(DeviceSession session) {
        this.registry.counter("received_messages", new String[]{"transport", session.getTransport().getId(), "deviceId", session.getDeviceId(), "server", this.getServerId()}).increment(-1.0);
    }
}

